/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.impl;

import bucket.core.persistence.hibernate.schema.TransientHibernateHandle;
import com.atlassian.confluence.importexport.impl.Operation;
import com.atlassian.confluence.importexport.impl.OperationSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Category;

public class DeferredOperations {
    private static Category log = Category.getInstance(DeferredOperations.class);
    private boolean doingDeferred = false;
    private Map operationSetsWaitingForThis = new HashMap();
    private Set deferredAdditions = new HashSet();

    public void reportOutstandingOperations() throws Exception {
        for (Set setOfSets : this.operationSetsWaitingForThis.values()) {
            for (OperationSet os : setOfSets) {
                log.warn((Object)("uncompleted deferred operations waiting for:" + os.getWaitingFor()));
                for (Operation o : os.getOperations()) {
                    log.warn((Object)o.getDescription());
                }
            }
        }
    }

    public void addDeferredOperation(Set waitingFor, Operation operation) {
        OperationSet operations = this.findOperationSetFor(waitingFor);
        if (operations == null) {
            operations = new OperationSet(waitingFor);
            for (TransientHibernateHandle key : waitingFor) {
                HashSet<OperationSet> s = (HashSet<OperationSet>)this.operationSetsWaitingForThis.get(key);
                if (s == null) {
                    s = new HashSet<OperationSet>();
                    this.operationSetsWaitingForThis.put(key, s);
                }
                s.add(operations);
            }
        }
        operations.addOperation(operation);
    }

    private OperationSet findOperationSetFor(Set waitingFor) {
        for (TransientHibernateHandle key : waitingFor) {
            Set s = (Set)this.operationSetsWaitingForThis.get(key);
            if (s == null) continue;
            for (OperationSet os : s) {
                if (!((Object)os.getWaitingFor()).equals(waitingFor)) continue;
                return os;
            }
        }
        return null;
    }

    public void doDeferredOperationsWaitingFor(TransientHibernateHandle key) throws Exception {
        if (this.doingDeferred) {
            this.deferredAdditions.add(key);
        } else {
            this.doingDeferred = true;
            Set keySets = (Set)this.operationSetsWaitingForThis.get(key);
            if (keySets != null) {
                for (OperationSet k : keySets) {
                    List l = k.getOperations();
                    if (k.getWaitingFor().size() == 1) {
                        for (Operation o : l) {
                            o.execute();
                        }
                    }
                    k.getWaitingFor().remove(key);
                }
                this.operationSetsWaitingForThis.remove(key);
            }
            this.doingDeferred = false;
            while (!this.deferredAdditions.isEmpty()) {
                ArrayList additions = new ArrayList(this.deferredAdditions);
                this.deferredAdditions.clear();
                for (TransientHibernateHandle objectKey : additions) {
                    this.doDeferredOperationsWaitingFor(objectKey);
                }
            }
        }
    }
}

