/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.impl;

import bucket.core.persistence.hibernate.schema.TransientHibernateHandle;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.importexport.ConfigurationMigrationEvent;
import com.atlassian.confluence.importexport.DefaultImportContext;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.impl.BackupImporter;
import com.atlassian.confluence.importexport.impl.ReverseDatabinder;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.DefaultAttachmentManager;
import com.atlassian.confluence.pages.persistence.dao.AttachmentDao;
import com.atlassian.confluence.pages.persistence.dao.FileSystemAttachmentDataDao;
import com.atlassian.confluence.pages.persistence.dao.SimpleFileLocationResolver;
import com.atlassian.confluence.pages.persistence.dao.hibernate.NonTransactionalHibernateAttachmentDao;
import com.atlassian.confluence.upgrade.VersionedAttachmentsUpgradeTask;
import com.atlassian.confluence.util.BandanaConfigMigrator;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.LayoutHelper;
import com.atlassian.confluence.util.velocity.ConfluenceVelocityResourceCache;
import com.atlassian.core.util.FileUtils;
import com.atlassian.event.Event;
import com.atlassian.spring.container.ContainerManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class FileBackupImporter
extends BackupImporter {
    private File extractedDir;
    private BandanaConfigMigrator bandanaConfigMigrator;

    public void doImport() throws ImportExportException {
        this.extractRestoreFile((DefaultImportContext)this.context);
        super.doImport();
        try {
            if (this.extractedDir != null) {
                this.deleteExtractedDir();
            }
        }
        catch (Exception e) {
            log.error((Object)("Could not delete temp dir: " + this.extractedDir));
        }
    }

    private void deleteExtractedDir() throws Exception {
        FileUtils.deleteDir((File)this.extractedDir);
    }

    private void extractRestoreFile(DefaultImportContext importContext) throws ImportExportException {
        try {
            if (importContext.getWorkingFile() != null) {
                String pathToRestoreFile = importContext.getWorkingFile();
                File backupedFile = new File(pathToRestoreFile);
                GeneralUtil.unzipFile(backupedFile, this.getExtractedDir());
            } else if (importContext.getWorkingURL() != null) {
                URL restoreFileUrl = importContext.getWorkingURL();
                GeneralUtil.unzipUrl(restoreFileUrl, this.getExtractedDir());
            }
        }
        catch (Exception e) {
            log.error((Object)"Error extracting backup zip from file or url.", (Throwable)e);
            if (e instanceof IOException) {
                throw new ImportExportException("Error unzipping file: " + e.getMessage());
            }
            throw new ImportExportException("Error extracting backup zip from file or url.");
        }
    }

    protected void importEverything() throws ImportExportException {
        ReverseDatabinder xmlReader = this.createXmlReader();
        boolean importAttachments = this.isBackupAttachments();
        super.importEverything(xmlReader, importAttachments);
        if (importAttachments) {
            this.importAttachments(xmlReader, this.getExtractedDir());
        }
        if (!this.isIncrementalImport()) {
            this.importTemplates();
            this.importConfigDirectory();
            this.importResourcesDirectory();
        }
        this.completeProgessMeter();
    }

    private Map getNamedBasedAttachmentPathMapping(ReverseDatabinder xmlReader, File srcAttachmentsDir, File destAttachmentsDir) throws ImportExportException {
        HashMap<File, File> pathMapping = new HashMap<File, File>();
        Session dbSession = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
        for (TransientHibernateHandle key : xmlReader.getAttachmentIds()) {
            Object obj;
            try {
                obj = key.get(dbSession);
            }
            catch (HibernateException he) {
                throw new ImportExportException("error retrieving attachment object " + key.getId(), he);
            }
            if (!(obj instanceof Attachment)) continue;
            ContentEntityObject content = ((Attachment)obj).getContent();
            Long newContentId = new Long(content.getId());
            Long oldContentId = xmlReader.getUnfixedIdFor(content.getClass(), newContentId);
            File dest = new File(destAttachmentsDir, newContentId.toString());
            File src = new File(srcAttachmentsDir, oldContentId.toString());
            pathMapping.put(src, dest);
        }
        return pathMapping;
    }

    private Map getIdBasedAttachmentPathMapping(ReverseDatabinder xmlReader, File srcAttachmentsDir, File destAttachmentsDir) throws ImportExportException {
        HashMap<File, File> pathMapping = new HashMap<File, File>();
        Session dbSession = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
        for (TransientHibernateHandle key : xmlReader.getAttachmentIds()) {
            Object obj;
            try {
                obj = key.get(dbSession);
            }
            catch (HibernateException he) {
                throw new ImportExportException("error retrieving attachment object " + key.getId(), he);
            }
            if (!(obj instanceof Attachment)) continue;
            Attachment attachment = (Attachment)obj;
            ContentEntityObject content = attachment.getContent();
            Long newContentId = new Long(content.getId());
            Long oldContentId = xmlReader.getUnfixedIdFor(content.getClass(), newContentId);
            Long newAttachmentId = new Long(attachment.getId());
            Long oldAttachmentId = xmlReader.getUnfixedIdFor(attachment.getClass(), newAttachmentId);
            File dest = new File(new File(destAttachmentsDir, newContentId.toString()), newAttachmentId.toString());
            File src = new File(new File(srcAttachmentsDir, oldContentId.toString()), oldAttachmentId.toString());
            pathMapping.put(src, dest);
        }
        return pathMapping;
    }

    private void copyPaths(Map pathMapping) {
        for (File src : pathMapping.keySet()) {
            File dest = (File)pathMapping.get(src);
            if (log.isInfoEnabled()) {
                log.info((Object)("Migrating attachments from: " + src + " to " + dest));
            }
            try {
                this.restoreDirectory(src, dest);
            }
            catch (Exception e) {
                log.error((Object)"There was a problem moving the attachments from the import to a temporary location.", (Throwable)e);
            }
        }
    }

    protected void importAttachments(ReverseDatabinder xmlReader, File extractedDir) throws ImportExportException {
        File srcAttachmentsDir = new File(extractedDir, "attachments");
        File fixedAttachmentsDir = new File(extractedDir, "attachments-new");
        fixedAttachmentsDir.mkdirs();
        Map pathMapping = this.importUsesFileNameAttachments() ? this.getNamedBasedAttachmentPathMapping(xmlReader, srcAttachmentsDir, fixedAttachmentsDir) : this.getIdBasedAttachmentPathMapping(xmlReader, srcAttachmentsDir, fixedAttachmentsDir);
        this.copyPaths(pathMapping);
        SimpleFileLocationResolver locationResolver = new SimpleFileLocationResolver(fixedAttachmentsDir);
        DefaultAttachmentManager sourceAttachmentManager = new DefaultAttachmentManager();
        ContainerManager.autowireComponent((Object)sourceAttachmentManager);
        NonTransactionalHibernateAttachmentDao filesystemAttachmentDao = new NonTransactionalHibernateAttachmentDao();
        ContainerManager.autowireComponent((Object)filesystemAttachmentDao);
        FileSystemAttachmentDataDao filesystemAttachmentDataDao = new FileSystemAttachmentDataDao();
        ContainerManager.autowireComponent((Object)filesystemAttachmentDataDao);
        filesystemAttachmentDataDao.setAttachmentsDirResolver(locationResolver);
        filesystemAttachmentDao.setDataDao(filesystemAttachmentDataDao);
        sourceAttachmentManager.setAttachmentDao(filesystemAttachmentDao);
        AttachmentManager destinationAttachmentManager = (AttachmentManager)ContainerManager.getComponent((String)"attachmentManager");
        this.fixAttachmentNaming(filesystemAttachmentDataDao);
        AttachmentDao.AttachmentCopier copier = sourceAttachmentManager.getCopier(destinationAttachmentManager);
        if (this.isIncrementalImport()) {
            copier.setSpacesToInclude(xmlReader.getImportedSpaces());
        }
        copier.copy();
        this.hackAroundUnversionedAttachmentFormat();
    }

    private void fixAttachmentNaming(FileSystemAttachmentDataDao filesystemAttachmentDataDao) throws ImportExportException {
        if (this.importUsesFileNameAttachments()) {
            filesystemAttachmentDataDao.setNamingStrategy(FileSystemAttachmentDataDao.NAMING_STRATEGY_FILE_NAME);
        }
    }

    private boolean importUsesFileNameAttachments() throws ImportExportException {
        try {
            return Integer.parseInt(this.getBuildNumberOfImport()) < 501;
        }
        catch (NumberFormatException nfe) {
            if (this.getBuildNumberOfImport().equals("@BUILD_NUMBER@")) {
                return false;
            }
            throw nfe;
        }
    }

    private void hackAroundUnversionedAttachmentFormat() throws ImportExportException {
        try {
            if (Integer.parseInt(this.getBuildNumberOfImport()) < 51) {
                try {
                    new VersionedAttachmentsUpgradeTask().doUpgrade();
                }
                catch (Exception e) {}
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void importTemplates() throws ImportExportException {
        ConfluenceVelocityResourceCache cache;
        if (this.restoreDirectory(this.getTemplateBackupDirectory(this.getExtractedDir()), new File(LayoutHelper.getFullTemplatePath())) && (cache = ConfluenceVelocityResourceCache.getInstance()) != null) {
            cache.clear();
        }
    }

    private File getTemplateBackupDirectory(File extractedDir) {
        File file = new File(extractedDir, "velocity");
        while (this.onlyContentsAreAnotherVelocityDirectory(file)) {
            file = new File(file, "velocity");
        }
        return file;
    }

    private boolean onlyContentsAreAnotherVelocityDirectory(File file) {
        String[] files = file.list();
        return files != null && files.length == 1 && files[0].equals("velocity");
    }

    private void importConfigDirectory() {
        File srcDir = new File(this.getExtractedDir(), "config");
        this.bandanaConfigMigrator.run(srcDir);
        this.eventManager.publishEvent((Event)new ConfigurationMigrationEvent(this));
    }

    private void importResourcesDirectory() {
        File srcDir = new File(this.getExtractedDir(), "resources");
        File destDir = new File(this.bootstrapManager.getConfluenceHome(), "resources");
        try {
            this.restoreDirectory(srcDir, destDir);
        }
        catch (ImportExportException e) {
            log.error((Object)("Error restoring config directory [" + destDir + "] from backup [" + srcDir + "]."));
        }
    }

    private boolean restoreDirectory(File srcDir, File destDir) throws ImportExportException {
        if (!srcDir.isDirectory()) {
            return false;
        }
        if (!destDir.isDirectory() && !destDir.mkdirs()) {
            throw new ImportExportException("Directory doesn't exist and can't be created within Confluence: " + destDir.getAbsolutePath());
        }
        try {
            FileUtils.copyDirectory((File)srcDir, (File)destDir, (boolean)true);
        }
        catch (IOException e) {
            String message = "Couldn't restore directory from backup! src: " + srcDir.getAbsolutePath() + " dest: " + destDir.getAbsolutePath();
            log.error((Object)message);
            throw new ImportExportException(message, e);
        }
        return true;
    }

    private File getExtractedDir() {
        if (this.extractedDir == null) {
            this.extractedDir = GeneralUtil.createTempDirectoryInConfluenceTemp("import");
        }
        return this.extractedDir;
    }

    protected InputStream getDescriptorPropertiesStream() throws ImportExportException {
        File file = new File(this.getExtractedDir(), "exportDescriptor.properties");
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new ImportExportException("Error finding and producing a stream of the export properties file: " + file);
        }
    }

    public InputStream getXmlEntitiesStream() throws ImportExportException {
        File xmlFile = new File(this.getExtractedDir(), "entities.xml");
        if (!xmlFile.isFile()) {
            throw new ImportExportException("The zip doesn't contain an 'entities.xml' file in it.");
        }
        try {
            return new FileInputStream(xmlFile);
        }
        catch (FileNotFoundException e) {
            throw new ImportExportException("Error finding and loading entities.xml into a stream.");
        }
    }

    public void setBandanaConfigMigrator(BandanaConfigMigrator bandanaConfigMigrator) {
        this.bandanaConfigMigrator = bandanaConfigMigrator;
    }
}

