/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.impl;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.ObjectHandleTranslator;
import com.atlassian.confluence.importexport.impl.AbstractXmlExporter;
import com.atlassian.confluence.importexport.impl.HibernateObjectHandleTranslator;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.persistence.dao.AttachmentDao;
import com.atlassian.confluence.pages.persistence.dao.AttachmentDaoFactory;
import com.atlassian.confluence.pages.persistence.dao.FileSystemAttachmentDataDao;
import com.atlassian.confluence.pages.persistence.dao.SimpleFileLocationResolver;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.core.util.FileUtils;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.spring.container.ContainerManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.hibernate.SessionFactory;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public abstract class FileXmlExporter
extends AbstractXmlExporter {
    protected AttachmentManager attachmentManager;

    public String doExport(ProgressMeter progress) throws ImportExportException {
        super.doExport(new HibernateObjectHandleTranslator(SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true)), progress);
        progress.setStatus("Zipping export files.");
        ConfluenceEntityObject firstEntity = null;
        if (this.getWorkingExportContext() != null && this.getWorkingExportContext().getWorkingEntities().size() > 0) {
            firstEntity = (ConfluenceEntityObject)this.getWorkingExportContext().getWorkingEntities().get(0);
        }
        String archivePath = this.bootstrapManager.getFilePathProperty("webwork.multipart.saveDir") + File.separator + this.prepareExportFileName(firstEntity) + ".zip";
        try {
            File zippedExport = new File(archivePath);
            FileUtils.createZipFile((File)this.getWorkingExportContext().getExportDirectory(), (File)zippedExport);
            FileUtils.deleteDir((File)this.getWorkingExportContext().getExportDirectory());
            return archivePath;
        }
        catch (Exception e) {
            throw new ImportExportException(e);
        }
    }

    protected void backupEverything(ObjectHandleTranslator translator, ProgressMeter progress) throws ImportExportException {
        super.backupEverything(translator, progress);
        if (!this.bootstrapManager.isWebdavEnabled() && this.getContext().isExportAttachments()) {
            this.backupAttachments();
        }
        this.backupTemplates();
        if ("all".equals(this.getExportType())) {
            this.backupConfigFiles();
            this.backupResources();
        }
    }

    protected abstract List getIncludedSpaces();

    protected void backupAttachments() throws ImportExportException {
        AttachmentDaoFactory attachmentDaoFactory = (AttachmentDaoFactory)ContainerManager.getComponent((String)"attachmentDaoFactory");
        File attachmentDir = new File(this.getWorkingExportContext().getExportDirectory(), "attachments");
        this.ensureDirectoryCreated(attachmentDir);
        SimpleFileLocationResolver locationResolver = new SimpleFileLocationResolver(attachmentDir);
        FileSystemAttachmentDataDao exportDataDao = new FileSystemAttachmentDataDao();
        exportDataDao.setAttachmentsDirResolver(locationResolver);
        AttachmentDao exportDao = attachmentDaoFactory.getInstance(exportDataDao);
        AttachmentDao sourceDao = this.attachmentManager.getAttachmentDao();
        AttachmentDao.AttachmentCopier copier = sourceDao.getCopier(exportDao);
        copier.setParentContentToExclude(this.getObjectsExcludedFromExport());
        copier.setSpacesToInclude(this.getIncludedSpaces());
        copier.copy();
    }

    protected void backupResources() throws ImportExportException {
        File resourceDir = new File(this.getWorkingExportContext().getExportDirectory(), "resources");
        this.ensureDirectoryCreated(resourceDir);
        try {
            if (this.getExportType().equals("all")) {
                File baseResourceDir = new File(this.bootstrapManager.getConfluenceHome() + File.separator + "resources");
                FileUtils.copyDirectory((File)baseResourceDir, (File)resourceDir);
            } else if (this.getExportType().equals("space")) {
                List baseResourceDirs = this.getEntityResourceDirectories();
                this.copyDirectories(baseResourceDirs, resourceDir);
            }
        }
        catch (IOException e) {
            this.log.error((Object)"Couldn't backup attachments.", (Throwable)e);
            throw new ImportExportException("Couldn't backup attachments.", e);
        }
    }

    protected void backupTemplates() throws ImportExportException {
        File templatesDir = this.getWorkingExportContext().getExportDirectory();
        this.ensureDirectoryCreated(templatesDir);
        try {
            List templateDirs = this.getSourceTemplateDirForCopying();
            this.copyDirectories(templateDirs, templatesDir);
        }
        catch (IOException e) {
            this.log.error((Object)"Couldn't backup template directory", (Throwable)e);
            throw new ImportExportException("Couldn't backup templates directory");
        }
    }

    protected void backupConfigFiles() throws ImportExportException {
        File configDirectory = this.getWorkingExportContext().getExportDirectory();
        File currentConfigDirectory = new File(this.bootstrapManager.getConfluenceHome() + File.separator + "config");
        if (currentConfigDirectory.exists()) {
            ArrayList<File> currentConfigDirAsList = new ArrayList<File>();
            currentConfigDirAsList.add(currentConfigDirectory);
            try {
                this.copyDirectories(currentConfigDirAsList, configDirectory);
            }
            catch (IOException e) {
                this.log.error((Object)("Error copying config directory over to backup. Directory: " + currentConfigDirectory), (Throwable)e);
            }
        }
    }

    private void copyDirectories(List sourceDirs, File targetDir) throws IOException {
        for (int i = 0; i < sourceDirs.size(); ++i) {
            File sourceDir = (File)sourceDirs.get(i);
            File destDir = new File(targetDir, sourceDir.getName());
            if (!sourceDir.isDirectory()) continue;
            FileUtils.copyDirectory((File)sourceDir, (File)destDir);
        }
    }

    private List getEntityResourceDirectories() {
        String resourcePath = this.bootstrapManager.getConfluenceHome() + File.separator + "resources";
        ArrayList<File> entityResourceDirs = new ArrayList<File>();
        for (Object o : this.context.getWorkingEntities()) {
            File spaceResourceDir = null;
            if (!(o instanceof Space) || !(spaceResourceDir = new File(resourcePath + File.separator + ((Space)o).getKey())).exists()) continue;
            entityResourceDirs.add(spaceResourceDir);
        }
        return entityResourceDirs;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }
}

