/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.impl;

import bucket.core.persistence.hibernate.schema.TransientHibernateHandle;
import com.atlassian.confluence.importexport.impl.Operation;
import com.atlassian.confluence.importexport.impl.ReverseDatabinder;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.persister.ClassPersister;
import net.sf.hibernate.type.ComponentType;
import net.sf.hibernate.type.DateType;
import net.sf.hibernate.type.TimestampType;
import net.sf.hibernate.type.Type;
import org.apache.log4j.Category;

class ImportedObject {
    public static final Category log = Category.getInstance(ImportedObject.class);
    private DateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private DateFormat isoTimestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private DateFormat legacyDateFormat = new SimpleDateFormat("dd MMMM yyyy");
    private DateFormat legacyTimestampFormat = new SimpleDateFormat("dd MMMM yyyy HH:mm:ss");
    private Class objectClass;
    private Object objectId;
    private List compositeIdProperties;
    private List nonNullPropertySetOperations;
    private Object object;
    private ReverseDatabinder reverseDatabinder;

    public ImportedObject(ReverseDatabinder reverseDatabinder) {
        this.reverseDatabinder = reverseDatabinder;
    }

    public Class getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(Class objectClass) {
        this.objectClass = objectClass;
    }

    public Object getObjectId() {
        return this.objectId;
    }

    public void setObjectId(Object objectId) {
        this.objectId = objectId;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public void addCompositeIdProperty(String property) {
        if (this.compositeIdProperties == null) {
            this.compositeIdProperties = new ArrayList();
        }
        this.compositeIdProperties.add(property);
    }

    public void addNonNullPropertySetOperation(Operation operation) {
        if (this.nonNullPropertySetOperations == null) {
            this.nonNullPropertySetOperations = new ArrayList();
        }
        this.nonNullPropertySetOperations.add(operation);
    }

    public void readObjectId(String id) throws Exception {
        ClassPersister entityPersister = this.getPersister(this.getObjectClass());
        Type idType = entityPersister.getIdentifierType();
        Class objectClass = this.getObjectClass();
        Constructor constructor = objectClass.getConstructor(null);
        constructor.setAccessible(true);
        this.setObject(objectClass.newInstance());
        this.setObjectId(this.idFromString(idType, id));
    }

    public void readCompositeObjectId() throws Exception {
        String[] properties = this.compositeIdProperties.toArray(new String[this.compositeIdProperties.size()]);
        ClassPersister entityPersister = this.getPersister(this.getObjectClass());
        this.setObject(this.getObjectClass().newInstance());
        this.setObjectId(this.compositeIdFromXML(entityPersister, properties));
    }

    protected ClassPersister getPersister(Class klass) throws MappingException {
        return this.reverseDatabinder.getPersister(klass);
    }

    private Object compositeIdFromXML(ClassPersister persister, String[] properties) throws HibernateException {
        if (this.compositeIdProperties == null) {
            throw new IllegalStateException("Composite ID specified but no ID properties set. Class " + this.getObjectClass().getName());
        }
        ComponentType idType = (ComponentType)persister.getIdentifierType();
        Object id = idType.instantiate(null, null);
        Type[] subtypes = idType.getSubtypes();
        Object[] idValues = new Object[subtypes.length];
        for (int i = 0; i < subtypes.length; ++i) {
            idValues[i] = this.idFromString(subtypes[i], properties[i]);
        }
        idType.setPropertyValues(id, idValues);
        return id;
    }

    protected boolean isPersistentObject(TransientHibernateHandle key) {
        return this.reverseDatabinder.isPersistentObject(key);
    }

    protected Object idFromString(Type type, String str) throws HibernateException {
        if (str != null) {
            str = str.trim();
        }
        if (type instanceof TimestampType || type instanceof DateType) {
            try {
                if (str == null || str.length() == 0) {
                    return null;
                }
                if (type instanceof TimestampType) {
                    return this.parseTimestamp(str);
                }
                return this.parseDate(str);
            }
            catch (ParseException e) {
                log.warn((Object)("Could not parse " + str + " as type " + type));
                return null;
            }
        }
        return type.fromString(str);
    }

    private Object parseTimestamp(String str) throws ParseException {
        try {
            return this.isoTimestampFormat.parse(str);
        }
        catch (ParseException e) {
            return this.legacyTimestampFormat.parse(str);
        }
    }

    private Object parseDate(String str) throws ParseException {
        try {
            return this.isoDateFormat.parse(str);
        }
        catch (ParseException e) {
            return this.legacyDateFormat.parse(str);
        }
    }

    public ReverseDatabinder getReverseDatabinder() {
        return this.reverseDatabinder;
    }

    public Object lookupPersistentObject(TransientHibernateHandle key) throws HibernateException {
        return this.reverseDatabinder.lookupPersistentObject(key);
    }

    public TransientHibernateHandle readId(Class clazz, String idString) throws Exception {
        ClassPersister persister = this.getPersister(clazz);
        Type idType = persister.getIdentifierType();
        Object id = this.idFromString(idType, idString);
        return new TransientHibernateHandle(clazz, id);
    }

    public void saveObject() throws Exception {
        if (this.nonNullPropertySetOperations == null || this.nonNullPropertySetOperations.isEmpty()) {
            this.reverseDatabinder.writeObject(this.getObject(), this.getObjectId(), this.getObjectClass());
        } else {
            this.reverseDatabinder.deferWriteObject(this.object, this.objectId, this.objectClass, this.nonNullPropertySetOperations);
        }
    }
}

