/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.impl;

import bucket.core.persistence.hibernate.schema.TransientHibernateHandle;
import bucket.user.propertyset.BucketPropertySetItem;
import com.atlassian.confluence.core.BodyContent;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.NotExportable;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.exception.ParentNotFoundException;
import com.atlassian.confluence.importexport.impl.BackupImporter;
import com.atlassian.confluence.importexport.impl.DeferredOperations;
import com.atlassian.confluence.importexport.impl.ImportedCollection;
import com.atlassian.confluence.importexport.impl.ImportedObject;
import com.atlassian.confluence.importexport.impl.ImportedProperty;
import com.atlassian.confluence.importexport.impl.Operation;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.mail.Mail;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.persistence.dao.hibernate.AliasedKey;
import com.atlassian.confluence.security.persistence.dao.hibernate.KeyTransferBean;
import com.atlassian.confluence.security.persistence.dao.hibernate.legacy.HibernateKey;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.io.IOUtils;
import com.atlassian.core.util.ProgressMeter;
import com.opensymphony.module.propertyset.hibernate.PropertySetItem;
import com.opensymphony.util.TextUtils;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.NonUniqueObjectException;
import net.sf.hibernate.Session;
import net.sf.hibernate.Transaction;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.id.Assigned;
import net.sf.hibernate.id.IdentifierGenerator;
import net.sf.hibernate.metadata.ClassMetadata;
import net.sf.hibernate.persister.ClassPersister;
import org.apache.log4j.Category;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReverseDatabinder
extends DefaultHandler {
    private static Category log = Category.getInstance(ReverseDatabinder.class);
    private static final int EXPECTING_OBJECT = 1;
    private static final int EXPECTING_OBJECT_ID = 2;
    private static final int READING_COMPOSITE_ID = 3;
    private static final int READING_OBJECT_BODY = 4;
    private static final int EXPECTING_PROPERTY_ID = 5;
    private static final int READING_PROPERTY = 6;
    private static final int READING_COLLECTION = 7;
    private static final int SKIP_OBJECT = 8;
    private int state = 1;
    private SessionFactoryImplementor factory;
    private SessionImplementor session;
    private boolean preserveIds;
    private Session dbSession;
    private DeferredOperations deferredOperations = new DeferredOperations();
    private List attachmentIds = new ArrayList();
    private List spaceIds = new ArrayList();
    private CharArrayWriter contents = new CharArrayWriter();
    private ImportedObject importedObject;
    private ImportedProperty importedProperty;
    private ImportedCollection importedCollection;
    private ProgressMeter meter;
    private LabelManager labelManager;
    private Set writtenIds = new HashSet();
    private Map fixedIds = new HashMap();
    private Map unfixedIds = new HashMap();
    private int writtenCount = 0;
    private Transaction tx = null;
    private int truncationCount = 0;

    public ReverseDatabinder(SessionFactoryImplementor factory, SessionImplementor session, boolean preserveIds, LabelManager labelManager) {
        this.factory = factory;
        this.session = session;
        this.preserveIds = preserveIds;
        this.labelManager = labelManager;
    }

    public void fromXML(BackupImporter importer, Session session, ProgressMeter meter) throws HibernateException, ImportExportException, IOException {
        int objectsToLoad = this.initProgressMeter(meter, importer);
        InputStream is = null;
        if (log.isInfoEnabled()) {
            log.info((Object)(objectsToLoad + " objects to load."));
        }
        this.dbSession = session;
        try {
            is = importer.getXmlEntitiesStream();
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(false);
            SAXParser parser = saxParserFactory.newSAXParser();
            this.tx = session.beginTransaction();
            parser.parse(is, (DefaultHandler)this);
            session.flush();
            session.clear();
            if (this.tx != null) {
                this.tx.commit();
            }
            this.deferredOperations.reportOutstandingOperations();
            meter.setCurrentCount(objectsToLoad);
        }
        catch (SAXParseException e) {
            log.error((Object)("Error parsing entities.xml : line [" + e.getLineNumber() + "], col [" + e.getColumnNumber() + "]. "), (Throwable)e);
            throw new HibernateException("Error processing backup. Refer to logs for more details", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Error processing backup: ", (Throwable)e);
            throw new HibernateException("Error processing backup. Refer to logs for more details.", (Throwable)e);
        }
        finally {
            IOUtils.close(is);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            if (qName.equals("hibernate-generic")) {
                this.state = 1;
            } else if (this.state == 1 && qName.equals("object")) {
                this.readObject(attributes);
                this.state = NotExportable.class.isAssignableFrom(this.importedObject.getObjectClass()) ? 8 : 2;
            } else if (!(this.state == 3 && qName.equals("property") || (this.state == 2 || this.state == 5 || this.state == 7) && qName.equals("id"))) {
                if (this.state == 2 && qName.equals("composite-id")) {
                    this.state = 3;
                } else if (this.state == 4 && qName.equals("property")) {
                    this.state = this.startProperty(attributes);
                } else if (this.state == 4 && qName.equals("collection")) {
                    this.startCollection(attributes);
                    this.state = 7;
                } else if (this.state == 7 && qName.equals("element")) {
                    this.startCollectionElement(attributes);
                } else if (this.state != 8) {
                    throw new SAXException("unexpected start of element " + qName + " in state " + this.state);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new SAXException("Error while parsing", e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (!qName.equals("hibernate-generic")) {
                if (this.state == 2 && qName.equals("id")) {
                    this.importedObject.readObjectId(this.getContents());
                    this.state = 4;
                } else if (this.state == 5 && qName.equals("id")) {
                    this.readPropertyId(this.dbSession);
                    this.state = 4;
                } else if (this.state == 7 && qName.equals("id")) {
                    this.endCollectionElement();
                } else if (this.state == 3 && qName.equals("property")) {
                    this.importedObject.addCompositeIdProperty(this.getContents());
                } else if (this.state == 3 && qName.equals("composite-id")) {
                    this.importedObject.readCompositeObjectId();
                    this.state = 4;
                } else if (this.state != 4 || !qName.equals("property")) {
                    if (this.state == 6 && qName.equals("property")) {
                        this.endProperty();
                        this.state = 4;
                    } else if (this.state == 4 && qName.equals("object")) {
                        this.endObject();
                        this.state = 1;
                    } else if (this.state != 7 || !qName.equals("element")) {
                        if (this.state == 7 && qName.equals("collection")) {
                            this.importedCollection = null;
                            this.state = 4;
                        } else if (this.state == 8) {
                            if (qName.equals("object")) {
                                this.state = 1;
                            }
                        } else {
                            throw new SAXException("unexpected end of element " + qName + " in state " + this.state);
                        }
                    }
                }
            }
            this.contents.reset();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new SAXException("Error while parsing", e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contents.write(ch, start, length);
    }

    public String getContents() {
        return this.contents.toString();
    }

    public Set getWrittenIds() {
        return this.writtenIds;
    }

    public Long getUnfixedIdFor(Class clazz, Long pageId) {
        if (this.preserveIds) {
            return pageId;
        }
        TransientHibernateHandle key = new TransientHibernateHandle(clazz, (Object)pageId);
        return (Long)this.unfixedIds.get(key);
    }

    protected void deferAddCollectionElement(TransientHibernateHandle[] keys, TransientHibernateHandle target, String collectionName, TransientHibernateHandle objectToInsertKey) {
        this.addDeferredOperation(keys, new AddCollectionElement(target, collectionName, objectToInsertKey));
    }

    private void readObject(Attributes attributes) throws Exception {
        this.importedObject = new ImportedObject(this);
        this.importedObject.setObjectClass(this.getClassForElement(attributes.getValue("class"), attributes.getValue("package")));
    }

    private int startProperty(Attributes attributes) throws Exception {
        this.contents.reset();
        this.importedProperty = new ImportedProperty(this.importedObject);
        this.importedProperty.setPropertyName(attributes.getValue("name"));
        if (attributes.getValue("class") != null) {
            this.importedProperty.setPropertyClass(this.getClassForElement(attributes.getValue("class"), attributes.getValue("package")));
            return 5;
        }
        return 6;
    }

    private void readPropertyId(Session dbSession) throws Exception {
        this.importedProperty.saveReferenceProperty(dbSession, this.getContents());
    }

    protected void deferSetObjectPropertyOnId(TransientHibernateHandle key, TransientHibernateHandle objectKey, String propertyName) {
        this.addDeferredOperation(new TransientHibernateHandle[]{key, objectKey}, new SetObjectPropertyOnId(objectKey, propertyName, key));
    }

    protected SetObjectPropertyOnObject makeSetObjectPropertyOperation(Object object, String propertyName, TransientHibernateHandle key) {
        return new SetObjectPropertyOnObject(object, propertyName, key);
    }

    private void endProperty() throws Exception {
        if (ContentEntityObject.class.isAssignableFrom(this.importedObject.getObjectClass()) && "content".equals(this.importedProperty.getPropertyName())) {
            this.migrateToNewContentFormat();
        } else {
            this.importedProperty.saveLiteralProperty(this.getContents());
        }
    }

    private void migrateToNewContentFormat() throws Exception {
        ImportedObject bodyContent = new ImportedObject(this);
        bodyContent.setObjectClass(BodyContent.class);
        bodyContent.setObject(bodyContent.getObjectClass().newInstance());
        ClassPersister persister = this.getPersister(BodyContent.class);
        IdentifierGenerator generator = persister.getIdentifierGenerator();
        bodyContent.setObjectId(generator.generate(this.session, (Object)bodyContent));
        ImportedProperty bodyProperty = new ImportedProperty(bodyContent);
        bodyProperty.setPropertyName("body");
        bodyProperty.saveLiteralProperty(this.getContents());
        bodyContent.addNonNullPropertySetOperation(this.makeSetObjectPropertyOperation(bodyContent.getObject(), "content", this.importedObject.readId(this.importedObject.getObjectClass(), this.importedObject.getObjectId().toString())));
        bodyContent.saveObject();
    }

    private void endObject() throws Exception {
        this.importedObject.saveObject();
    }

    protected void deferWriteObject(Object object, Object objectId, Class objectClass, List nonNullPropertySetOperations) {
        HashSet<TransientHibernateHandle> objectsForNonNullProperties = new HashSet<TransientHibernateHandle>();
        for (SetObjectPropertyOnObject sop : nonNullPropertySetOperations) {
            objectsForNonNullProperties.add(sop.getValueKey());
        }
        this.deferredOperations.addDeferredOperation(objectsForNonNullProperties, new WriteObject(object, objectId, objectClass, nonNullPropertySetOperations));
    }

    private void startCollection(Attributes attributes) throws Exception {
        this.importedCollection = new ImportedCollection(this.importedObject);
        this.importedCollection.setCollectionName(attributes.getValue("name"));
        this.importedCollection.initCollection(this.session);
    }

    private void startCollectionElement(Attributes attributes) throws Exception {
        this.importedCollection.setNextCollectionElementClass(this.getClassForElement(attributes.getValue("class"), attributes.getValue("package")));
    }

    private void endCollectionElement() throws Exception {
        this.importedCollection.addCollectionElementReference(this.getContents());
    }

    protected void writeObject(Object object, Object objectId, Class objectClass) throws Exception {
        Object fixedObjectId;
        if (objectClass == HibernateKey.class) {
            HibernateKey hKey = (HibernateKey)object;
            KeyTransferBean transfer = new KeyTransferBean(hKey.getKeyType(), hKey.getAlgorithm(), hKey.getEncodedKey());
            AliasedKey aliased = new AliasedKey();
            aliased.setAlias(hKey.getAlias());
            aliased.setKey(transfer.asKey());
            this.dbSession.save((Object)aliased);
            ++this.writtenCount;
            this.flushIfNeeded();
            return;
        }
        ClassPersister persister = this.getPersister(objectClass);
        try {
            fixedObjectId = this.getFixedIdFor(persister, objectId, object);
        }
        catch (ParentNotFoundException e) {
            log.warn((Object)("Could not find the parent object to import. Skipping object {class: " + objectClass.getName() + ", " + "id: " + objectId + "}"), (Throwable)e);
            return;
        }
        TransientHibernateHandle fixedKey = new TransientHibernateHandle(objectClass, fixedObjectId);
        TransientHibernateHandle unfixedKey = new TransientHibernateHandle(objectClass, objectId);
        persister.setIdentifier(object, (Serializable)fixedObjectId);
        if (this.writtenIds.contains(fixedKey)) {
            log.warn((Object)("Found duplicate key: " + unfixedKey + ", skipping second object in import"));
            return;
        }
        this.writtenIds.add(fixedKey);
        if (objectClass.equals(Attachment.class)) {
            this.attachmentIds.add(fixedKey);
        } else if (objectClass.equals(Space.class)) {
            this.spaceIds.add(fixedKey);
        }
        try {
            Attachment attachment;
            BucketPropertySetItem item;
            if (objectClass.equals(BucketPropertySetItem.class) && (item = (BucketPropertySetItem)object).getKey().length() > 200) {
                this.fixBucketPropertySetItemKey(item);
            }
            if (objectClass.equals(Attachment.class) && (attachment = (Attachment)object).getFileName() == null) {
                attachment.setFileName("");
            }
            if (!this.isExistingLabel(objectClass, fixedObjectId)) {
                if (objectId instanceof Object[]) {
                    this.dbSession.save(object);
                } else {
                    this.dbSession.save(object, (Serializable)fixedObjectId);
                }
                ++this.writtenCount;
            }
            this.deferredOperations.doDeferredOperationsWaitingFor(unfixedKey);
            this.flushIfNeeded();
        }
        catch (NonUniqueObjectException nuoe) {
            log.error((Object)"attempted to create duplicate object:", (Throwable)nuoe);
        }
    }

    private boolean isExistingLabel(Class<?> objectClass, Object fixedObjectId) {
        return objectClass.equals(Label.class) && this.labelManager.getLabel((Long)fixedObjectId) != null;
    }

    private void flushIfNeeded() throws HibernateException {
        if (this.writtenCount % 100 == 0) {
            this.dbSession.flush();
            this.dbSession.clear();
            this.tx.commit();
            this.tx = this.dbSession.beginTransaction();
            this.meter.setCurrentCount(this.writtenCount);
        }
    }

    private void fixBucketPropertySetItemKey(BucketPropertySetItem item) {
        StringTokenizer st;
        String key = item.getKey();
        String newKey = null;
        if (key.startsWith("tasklist.") && (st = new StringTokenizer(key, ".")).countTokens() >= 2) {
            String taskItemName;
            String taskListName = "";
            st.nextToken();
            if (st.countTokens() == 2) {
                taskListName = st.nextToken();
                taskItemName = st.nextToken();
            } else if (st.countTokens() == 1 && key.startsWith("tasklist..")) {
                taskItemName = st.nextToken();
            } else {
                taskListName = st.nextToken();
                String noPrefixString = key.substring(key.indexOf(".") + 1);
                int indexOfPeriod = noPrefixString.indexOf(".");
                taskItemName = noPrefixString.substring(indexOfPeriod + 1);
                log.warn((Object)("More than 2 tokens found for ENTITY_KEY=" + key + ". Best guess at tasklist name: " + taskListName));
            }
            try {
                Integer.parseInt(taskListName);
                Integer.parseInt(taskItemName);
                log.info((Object)("Skipping ENTITY_KEY=" + key + " as it has already been hashed."));
                newKey = key;
            }
            catch (NumberFormatException e) {
                int taskListNameHash = TextUtils.noNull((String)taskListName).hashCode();
                int taskItemNameHash = TextUtils.noNull((String)taskItemName).hashCode();
                newKey = taskListNameHash + "." + taskItemNameHash;
            }
        }
        if (newKey == null) {
            log.error((Object)("truncating property set item key: '" + key + "'"));
            newKey = key.substring(0, 190) + this.truncationCount++;
        }
        item.setKey(newKey);
    }

    private void addDeferredOperation(TransientHibernateHandle[] keys, Operation operation) {
        HashSet<TransientHibernateHandle> waitingFor = new HashSet<TransientHibernateHandle>();
        for (int i = 0; i < keys.length; ++i) {
            waitingFor.add(keys[i]);
        }
        this.deferredOperations.addDeferredOperation(waitingFor, operation);
    }

    private Class getClassForElement(String className, String packageName) throws ClassNotFoundException {
        if ("com.opensymphony.user.provider.hibernate.entity".equals(packageName)) {
            packageName = "com.opensymphony.user.provider.hibernate.impl";
            className = className + "Impl";
        }
        if ("com.atlassian.confluence.core".equals(packageName) && "ContentLock".equals(className)) {
            className = "ContentPermission";
        }
        if ("com.opensymphony.module.propertyset.hibernate".equals(packageName) && "PropertySetItem".equals(className)) {
            packageName = "bucket.user.propertyset";
            className = "BucketPropertySetItem";
        }
        if ("com.atlassian.confluence.core".equals(packageName) && "ContentPermission".equals(className)) {
            packageName = "com.atlassian.confluence.upgrade.security";
            className = "LegacyContentPermission";
        }
        if ("com.atlassian.confluence.security.persistence.dao.hibernate".equals(packageName) && "HibernateKey".equals(className)) {
            packageName = "com.atlassian.confluence.security.persistence.dao.hibernate.legacy";
            className = "HibernateKey";
        }
        String fullyQualifiedClassName = packageName + "." + className;
        return Class.forName(fullyQualifiedClassName);
    }

    protected ClassPersister getPersister(Class clazz) throws MappingException {
        return this.factory.getPersister(clazz);
    }

    public List getAttachmentIds() {
        return this.attachmentIds;
    }

    protected boolean isPersistentObject(TransientHibernateHandle key) {
        return this.fixedIds.get(key) != null;
    }

    protected Object lookupPersistentObject(TransientHibernateHandle key) throws HibernateException {
        if (!this.isPersistentObject(key)) {
            return null;
        }
        TransientHibernateHandle fixedKey = new TransientHibernateHandle(key.getClazz(), this.fixedIds.get(key));
        return fixedKey.get(this.dbSession);
    }

    private Object getFixedIdFor(ClassPersister persister, Object idValue, Object obj) throws HibernateException, SQLException {
        Object fixedId;
        Class mappedClass = persister.getMappedClass();
        TransientHibernateHandle key = new TransientHibernateHandle(mappedClass, idValue);
        if (this.preserveIds) {
            this.fixedIds.put(key, idValue);
            return idValue;
        }
        if (this.fixedIds.containsKey(key)) {
            return this.fixedIds.get(key);
        }
        if (mappedClass == BucketPropertySetItem.class) {
            PropertySetItem compositeKey = (PropertySetItem)idValue;
            Long importEntityId = new Long(compositeKey.getEntityId());
            Long fixedEntityId = this.getFixedEntityIdForPropertySetItem(importEntityId);
            if (fixedEntityId == null) {
                throw new ParentNotFoundException("Was unable to locate the fixed reference for the BucketPropertySetItem. entity_name = " + compositeKey.getEntityName() + ", " + "entity_id = " + compositeKey.getEntityId() + ", " + "entity_key = " + compositeKey.getKey());
            }
            compositeKey.setEntityId(fixedEntityId.longValue());
            fixedId = compositeKey;
        } else {
            Label persistentLabel;
            IdentifierGenerator identifierGenerator = persister.getIdentifierGenerator();
            fixedId = identifierGenerator instanceof Assigned ? idValue : (mappedClass == Label.class ? ((persistentLabel = this.labelManager.getLabel((Label)obj)) == null ? identifierGenerator.generate(this.session, obj) : new Long(persistentLabel.getId())) : identifierGenerator.generate(this.session, obj));
        }
        this.fixedIds.put(key, fixedId);
        TransientHibernateHandle unfixedKey = new TransientHibernateHandle(mappedClass, fixedId);
        this.unfixedIds.put(unfixedKey, idValue);
        return fixedId;
    }

    private Long getFixedEntityIdForPropertySetItem(Long entityId) {
        Class[] entityClasses = new Class[]{Page.class, BlogPost.class, Mail.class};
        for (int i = 0; i < entityClasses.length; ++i) {
            Class entityClass = entityClasses[i];
            TransientHibernateHandle handle = new TransientHibernateHandle(entityClass, (Object)entityId);
            if (!this.fixedIds.containsKey(handle)) continue;
            return (Long)this.fixedIds.get(handle);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int initProgressMeter(ProgressMeter meter, BackupImporter importer) throws ImportExportException, IOException {
        this.meter = meter;
        meter.setStatus("Counting objects to import");
        int objectsToLoad = 0;
        InputStream is = null;
        try {
            is = importer.getXmlEntitiesStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = reader.readLine();
            while (line != null) {
                if (line.indexOf("<object") != -1) {
                    ++objectsToLoad;
                }
                line = reader.readLine();
            }
            meter.setTotalObjects(objectsToLoad * 2);
            meter.setStatus("Importing objects");
            int n = objectsToLoad;
            return n;
        }
        finally {
            IOUtils.close(is);
        }
    }

    public List getImportedSpaces() throws ImportExportException {
        ArrayList<Space> result = new ArrayList<Space>();
        for (TransientHibernateHandle handle : this.spaceIds) {
            Space space;
            try {
                space = (Space)handle.get(this.dbSession);
            }
            catch (HibernateException e) {
                throw new ImportExportException("Could not get space object back from database: " + e.getMessage(), e);
            }
            result.add(space);
        }
        return result;
    }

    private class AddCollectionElement
    implements Operation {
        private final TransientHibernateHandle target;
        private final String collectionName;
        private final TransientHibernateHandle objectToInsertKey;

        public AddCollectionElement(TransientHibernateHandle target, String collectionName, TransientHibernateHandle objectToInsertKey) {
            this.target = target;
            this.collectionName = collectionName.intern();
            this.objectToInsertKey = objectToInsertKey;
        }

        public void execute() throws Exception {
            Object targetObject = ReverseDatabinder.this.lookupPersistentObject(this.target);
            Object objectToInsert = ReverseDatabinder.this.lookupPersistentObject(this.objectToInsertKey);
            if (targetObject == null || objectToInsert == null) {
                throw new RuntimeException(this.getDescription() + " failed.");
            }
            ClassPersister persister = ReverseDatabinder.this.getPersister(this.target.getClazz());
            Collection collection = (Collection)persister.getPropertyValue(targetObject, this.collectionName);
            collection.add(objectToInsert);
        }

        public String getDescription() {
            return "add the object " + this.objectToInsertKey + " to the collection named " + this.collectionName + " of " + this.target;
        }
    }

    private class WriteObject
    implements Operation {
        private final Object object;
        private final Object objectId;
        private final Class objectClass;
        private final List nullPropertySetOperations;

        public WriteObject(Object object, Object objectId, Class objectClass, List nullPropertySetOperations) {
            this.object = object;
            this.objectId = objectId;
            this.objectClass = objectClass;
            this.nullPropertySetOperations = nullPropertySetOperations;
        }

        public void execute() throws Exception {
            for (Operation o : this.nullPropertySetOperations) {
                o.execute();
            }
            ReverseDatabinder.this.writeObject(this.object, this.objectId, this.objectClass);
        }

        public String getDescription() {
            return "write the object of class " + this.objectClass.getName() + " with id " + this.objectId;
        }
    }

    private class SetObjectPropertyOnObject
    extends SetObjectProperty {
        private Object target;

        public SetObjectPropertyOnObject(Object target, String propertyName, TransientHibernateHandle key) {
            super(propertyName, key);
            this.target = target;
        }

        protected Object getTarget() {
            return this.target;
        }
    }

    private class SetObjectPropertyOnId
    extends SetObjectProperty {
        private TransientHibernateHandle targetKey;

        public SetObjectPropertyOnId(TransientHibernateHandle targetKey, String propertyName, TransientHibernateHandle key) {
            super(propertyName, key);
            this.targetKey = targetKey;
        }

        protected Object getTarget() throws HibernateException {
            return ReverseDatabinder.this.lookupPersistentObject(this.targetKey);
        }
    }

    private abstract class SetObjectProperty
    implements Operation {
        private String propertyName;
        private TransientHibernateHandle valueKey;

        public SetObjectProperty(String propertyName, TransientHibernateHandle valueKey) {
            this.propertyName = propertyName;
            this.valueKey = valueKey;
        }

        public TransientHibernateHandle getValueKey() {
            return this.valueKey;
        }

        protected abstract Object getTarget() throws Exception;

        public void execute() throws Exception {
            Object target = this.getTarget();
            Object value = ReverseDatabinder.this.lookupPersistentObject(this.valueKey);
            if (target == null || value == null) {
                throw new RuntimeException(this.getDescription() + " failed.");
            }
            ClassPersister persister = ReverseDatabinder.this.getPersister(Hibernate.getClass((Object)target));
            ((ClassMetadata)persister).setPropertyValue(target, this.propertyName, value);
        }

        public String getDescription() throws Exception {
            return "set the " + this.propertyName + " property of " + this.getTarget() + " to " + this.valueKey;
        }
    }
}

