/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.impl;

import com.atlassian.confluence.util.zip.FileUnzipper;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;

public class UnexpectedImportZipFileContents
extends Throwable {
    private final String name;
    private final File exportZip;

    public UnexpectedImportZipFileContents(String name, File exportZip) {
        this.name = name;
        this.exportZip = exportZip;
    }

    public String getMessage() {
        String entries = "";
        try {
            ZipEntry[] zipEntries = new FileUnzipper(this.exportZip, null).entries();
            entries = zipEntries.length > 0 ? "It contained: " : "It did not contain any files, or was not a valid zip file.";
            String sep = "";
            for (int i = 0; i < zipEntries.length; ++i) {
                entries = entries + sep + zipEntries[i].getName();
                sep = ", ";
            }
        }
        catch (IOException e) {
            entries = "Error determining contents of zip file:" + e.getMessage();
        }
        return "The zip file did not contain an entry '" + this.name + "'. " + entries;
    }
}

