/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.impl;

import com.atlassian.confluence.util.ConfluenceRenderUtils;
import com.opensymphony.util.TextUtils;
import com.steadystate.css.parser.CSSOMParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.log4j.Category;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;

class XHtmlCSSIntegrator {
    private static Category log = Category.getInstance(XHtmlCSSIntegrator.class);
    private CSSRuleList rules;
    private static final ErrorHandler ERROR_HANDLER = new ErrorHandler(){

        public void warning(CSSParseException e) throws CSSException {
            log.debug((Object)e);
        }

        public void error(CSSParseException e) throws CSSException {
            log.debug((Object)e);
        }

        public void fatalError(CSSParseException e) throws CSSException {
            log.debug((Object)e);
        }
    };

    public XHtmlCSSIntegrator() throws IOException {
        String defaultStylesheet = ConfluenceRenderUtils.renderDefaultStylesheet();
        StringReader reader = new StringReader(defaultStylesheet);
        try {
            CSSOMParser cssomParser = new CSSOMParser();
            cssomParser.setErrorHandler(ERROR_HANDLER);
            CSSStyleSheet stylesheet = cssomParser.parseStyleSheet(new InputSource((Reader)reader), null, null);
            this.rules = stylesheet.getCssRules();
        }
        catch (CSSException csse) {
            log.error((Object)("error parsing stylesheet:'" + defaultStylesheet + "'"), (Throwable)csse);
            this.rules = null;
        }
    }

    public void applyStyleSheet(Node node) {
        if (this.rules == null) {
            return;
        }
        for (int i = 0; i < this.rules.getLength(); ++i) {
            CSSRule rule = this.rules.item(i);
            if (rule.getType() != 1) continue;
            this.applyStyleRule((CSSStyleRule)rule, node);
        }
    }

    private void applyStyleRule(CSSStyleRule styleRule, Node node) {
        CSSStyleDeclaration styleDeclaration = styleRule.getStyle();
        StringTokenizer st = new StringTokenizer(styleRule.getSelectorText(), ",");
        String styleText = "";
        for (int j = 0; j < styleDeclaration.getLength(); ++j) {
            String styleName = styleDeclaration.item(j);
            CSSValue styleValue = styleDeclaration.getPropertyCSSValue(styleName);
            if (styleValue.getCssValueType() != 1 && styleValue.getCssValueType() != 2) continue;
            styleText = styleText + styleName + ": " + styleValue.getCssText() + "; ";
        }
        while (st.hasMoreTokens()) {
            int dotIndex;
            String selector = st.nextToken().trim();
            if (selector.indexOf(58) != -1) continue;
            if (selector.startsWith("*#")) {
                selector = "*." + selector.substring(2);
            }
            if ((dotIndex = selector.indexOf(46)) != -1) {
                StringTokenizer st2 = new StringTokenizer(selector, " ");
                String xpath = "/";
                while (st2.hasMoreTokens()) {
                    String token = st2.nextToken();
                    dotIndex = token.indexOf(46);
                    if (dotIndex != -1) {
                        xpath = xpath + "/" + token.substring(0, dotIndex) + "[@class='" + token.substring(dotIndex + 1) + "']";
                        continue;
                    }
                    xpath = xpath + "/" + token;
                }
                this.appendStyleImpl(node, xpath, styleText);
                continue;
            }
            if (selector.startsWith("*")) continue;
            String tagName = selector;
            int spaceIndex = tagName.indexOf(32);
            if (spaceIndex != -1) {
                tagName = tagName.substring(0, spaceIndex);
            }
            if (tagName.equalsIgnoreCase("body") || tagName.equalsIgnoreCase("html")) continue;
            this.appendStyleImpl2(node, tagName, styleText);
        }
    }

    private void appendStyleImpl(Node node, String nodesPattern, String styleText) {
        for (Element element : node.selectNodes(nodesPattern)) {
            this.addAttribute(element, styleText);
        }
    }

    private void appendStyleImpl2(Node parent, String tag, String styleText) {
        if (parent.getNodeType() != 1) {
            return;
        }
        if (parent.getName().equalsIgnoreCase(tag)) {
            Element element = (Element)parent;
            this.addAttribute(element, styleText);
        }
        Iterator it = ((Element)parent).nodeIterator();
        while (it.hasNext()) {
            this.appendStyleImpl2((Node)it.next(), tag, styleText);
        }
    }

    private void addAttribute(Element node, String styleText) {
        ArrayList<String> addedStyleAttributes = new ArrayList<String>();
        Attribute styleAttribute = node.attribute("style");
        if (styleAttribute != null) {
            String explicitCssStyle = styleAttribute.getValue();
            if (!TextUtils.noNull((String)explicitCssStyle).trim().endsWith(";")) {
                explicitCssStyle = explicitCssStyle + ";";
            }
            styleText = explicitCssStyle + styleText;
        }
        StringTokenizer st = new StringTokenizer(styleText, ";");
        while (st.hasMoreTokens()) {
            String[] styleTextArray = TextUtils.noNull((String)st.nextToken()).split(":");
            if (styleTextArray.length != 2) continue;
            String attributeName = styleTextArray[0].trim();
            String attributeValue = TextUtils.noNull((String)styleTextArray[1]).trim();
            if (node.attribute(attributeName) != null || addedStyleAttributes.contains(attributeName)) continue;
            node.addAttribute(attributeName, attributeValue);
            addedStyleAttributes.add(attributeName);
        }
    }
}

