/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.impl.moinmoin;

import com.atlassian.confluence.importexport.DefaultImportContext;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.Importer;
import com.atlassian.confluence.importexport.impl.moinmoin.MoinMoinContentCleaner;
import com.atlassian.confluence.links.LinkManager;
import com.atlassian.confluence.links.ReferralManager;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.RegExpProcessor;
import java.io.File;

public class MoinMoinImporter
extends Importer {
    protected PageManager pageManager;
    protected UserAccessor userAccessor;
    private Space space;
    private CommentManager commentManager;
    private ReferralManager referralManager;
    private LinkManager linkManager;
    private MoinMoinContentCleaner contentCleaner = new MoinMoinContentCleaner();
    private RegExpProcessor regExpProcessor = new RegExpProcessor("\\[([^:\\[\\]]+)\\]", null);
    private SpaceManager spaceManager;

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setCommentManager(CommentManager commentManager) {
        this.commentManager = commentManager;
    }

    public void setReferralManager(ReferralManager referralManager) {
        this.referralManager = referralManager;
    }

    public void setLinkManager(LinkManager linkManager) {
        this.linkManager = linkManager;
    }

    public void doImport() throws ImportExportException {
        DefaultImportContext defaultImportContext = (DefaultImportContext)this.context;
        long spaceId = defaultImportContext.getDefaultSpace().getId();
        this.space = this.spaceManager.getSpace(spaceId);
        String exportPath = defaultImportContext.getWorkingFile();
        File exportDirectory = new File(exportPath);
        if (!exportDirectory.isDirectory()) {
            throw new ImportExportException("Invalid export directory specified.");
        }
        this.importAll(exportDirectory);
    }

    private void importAll(File exportDirectory) {
        this.importText(new File(exportDirectory, "text"));
    }

    private void importText(File textDirectory) {
    }

    private String makeName(File file) {
        return file.getName();
    }
}

