/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.impl.snipsnap;

import com.atlassian.confluence.importexport.impl.snipsnap.SnipSnapSnip;
import java.util.ArrayList;
import java.util.List;

public class BlogTidier {
    public static void tidyBlogs(List objects) {
        ArrayList<SnipSnapSnip> newBlogs = new ArrayList<SnipSnapSnip>(0);
        for (Object o : objects) {
            if (!(o instanceof SnipSnapSnip)) continue;
            SnipSnapSnip baseSnip = (SnipSnapSnip)o;
            baseSnip.setBlog();
            if (!baseSnip.isBlog()) continue;
            String[] bloglets = BlogTidier.getBlogLets(baseSnip.getContent());
            baseSnip.setContent(bloglets[0]);
            BlogTidier.setHeaderAndContent(baseSnip);
            for (int i = 1; i < bloglets.length; ++i) {
                SnipSnapSnip newSnip = new SnipSnapSnip();
                newSnip.setContent(bloglets[i]);
                newSnip.setAttachments(baseSnip.getAttachments());
                newSnip.setBackLinks(baseSnip.getBackLinks());
                newSnip.setCreated(baseSnip.getCreated());
                newSnip.setCreator(baseSnip.getCreator());
                newSnip.setModified(baseSnip.getModified());
                newSnip.setModifier(baseSnip.getModifier());
                newSnip.setBlog(true);
                BlogTidier.setHeaderAndContent(newSnip);
                newBlogs.add(newSnip);
            }
        }
        objects.addAll(newBlogs);
    }

    private static void setHeaderAndContent(SnipSnapSnip snip) {
        String content = snip.getContent();
        String[] sentences = content.split("\n", 2);
        if (sentences[0].length() > 150 && (sentences = content.split("\\.", 2)).length > 1) {
            sentences[0] = sentences[0].trim() + "\\.";
        }
        if (sentences.length > 1) {
            snip.setName(BlogTidier.cleanName(sentences[0]));
            snip.setContent(sentences[1].trim());
        }
    }

    private static String cleanName(String name) {
        name = name.replaceFirst("\\{.*\\}", "").trim();
        name = name.replaceFirst("^\\d\\s*", "").trim();
        name = name.replaceAll("__", "");
        return name;
    }

    private static String[] getBlogLets(String content) {
        String[] strings = content.trim().split("(?m)^1 ");
        ArrayList<String> blogLets = new ArrayList<String>(0);
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i].equals("")) continue;
            blogLets.add(strings[i]);
        }
        return blogLets.toArray(new String[blogLets.size()]);
    }
}

