/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.resource;

import com.atlassian.confluence.importexport.resource.DownloadResourceNotFoundException;
import com.atlassian.confluence.importexport.resource.DownloadResourceReader;
import com.atlassian.confluence.importexport.resource.DownloadResourceWriter;
import com.atlassian.confluence.importexport.resource.FileDownloadResourceReader;
import com.atlassian.confluence.importexport.resource.FileDownloadResourceWriter;
import com.atlassian.confluence.importexport.resource.UnauthorizedDownloadResourceException;
import com.atlassian.confluence.importexport.resource.WritableDownloadResourceManager;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.util.GeneralUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ExportDownloadResourceManager
implements WritableDownloadResourceManager {
    private static final Logger log = Logger.getLogger(ExportDownloadResourceManager.class);
    private BootstrapManager bootstrapManager;
    private GateKeeper gateKeeper;

    public boolean matches(String resourcePath) {
        return resourcePath.startsWith(this.getExportRoot().toLowerCase());
    }

    public DownloadResourceReader getResourceReader(String userName, String resourcePath, Map parameters) throws UnauthorizedDownloadResourceException, DownloadResourceNotFoundException {
        String path = this.bootstrapManager.getWebAppContextPath() + "/download";
        if (resourcePath.startsWith(path)) {
            resourcePath = resourcePath.substring(path.length(), resourcePath.length());
        } else {
            log.error((Object)("Incorrect resourcePath specified: " + resourcePath));
        }
        File file = new File(this.bootstrapManager.getConfluenceHome(), resourcePath);
        if (!this.gateKeeper.isAccessPermitted("download" + resourcePath, userName) || file.isDirectory()) {
            throw new UnauthorizedDownloadResourceException();
        }
        if (!file.exists()) {
            throw new DownloadResourceNotFoundException("Could not find file: " + resourcePath);
        }
        boolean deleteFileAfterUse = parameters.get("delete") != null;
        return new FileDownloadResourceReader(file, deleteFileAfterUse);
    }

    public DownloadResourceWriter getResourceWriter(String userName, String prefix, String suffix) {
        File file;
        try {
            file = File.createTempFile(prefix, suffix, GeneralUtil.getConfluenceTempDirectory());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create temporary file for macro output: prefix [" + prefix + "], " + "suffix [" + suffix + "]", e);
        }
        String path = this.getExportRoot().toLowerCase() + "/" + file.getName();
        this.gateKeeper.addKey(path, StringUtils.isBlank((String)userName) ? null : userName);
        return new FileDownloadResourceWriter(path, file);
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setGateKeeper(GateKeeper gateKeeper) {
        this.gateKeeper = gateKeeper;
    }

    private String getExportRoot() {
        int homeDirIndex;
        String exportDir = this.bootstrapManager.getFilePathProperty("webwork.multipart.saveDir");
        if (this.bootstrapManager.getConfluenceHome() != null && (homeDirIndex = exportDir.indexOf(this.bootstrapManager.getConfluenceHome())) != -1) {
            exportDir = exportDir.substring(homeDirIndex + this.bootstrapManager.getConfluenceHome().length() + 1);
        }
        return this.bootstrapManager.getWebAppContextPath() + "/download/" + exportDir;
    }
}

