/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.importexport.resource;

import com.atlassian.confluence.importexport.resource.DownloadResourceReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.log4j.Logger;

public class FileDownloadResourceReader
implements DownloadResourceReader {
    private static final Logger log = Logger.getLogger(FileDownloadResourceReader.class);
    private final File file;
    private boolean deleteFileOnClose;

    public FileDownloadResourceReader(File file, boolean deleteFileOnClose) {
        this.file = file;
        this.deleteFileOnClose = deleteFileOnClose;
    }

    public String getName() {
        return this.file.getName();
    }

    public String getContentType() {
        throw new UnsupportedOperationException("This operation is not supported by the FileDownloadResourceReader");
    }

    public long getContentLength() {
        return this.file.length();
    }

    public Date getLastModificationDate() {
        return new Date(this.file.lastModified());
    }

    public InputStream getStreamForReading() {
        FileInputStream inputStream;
        try {
            inputStream = new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Could not open macro temporary file for reading [" + this.file + "]", e);
        }
        if (this.deleteFileOnClose) {
            return new FilterInputStream(inputStream){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        if (FileDownloadResourceReader.this.file.exists() && !FileDownloadResourceReader.this.file.delete()) {
                            log.warn((Object)("Could not delete file " + FileDownloadResourceReader.this.file));
                        }
                    }
                }
            };
        }
        return inputStream;
    }
}

