/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.jmx;

import com.atlassian.confluence.search.IndexingTask;
import com.atlassian.confluence.search.lucene.ConfluenceIndexManager;
import com.atlassian.confluence.search.lucene.FlushStatistics;
import com.atlassian.confluence.search.lucene.IndexTaskQueue;
import java.util.Date;

public class JmxIndexManagerWrapper {
    private ConfluenceIndexManager indexManager;

    public JmxIndexManagerWrapper(ConfluenceIndexManager indexManager) {
        this.indexManager = indexManager;
    }

    public boolean isFlushing() {
        return this.indexManager.isFlushing();
    }

    public boolean isReIndexing() {
        return this.indexManager.isReIndexing();
    }

    public String getLastReindexingTaskName() {
        IndexingTask reindexingTask = this.indexManager.getLastReindexingTask();
        if (reindexingTask == null) {
            return null;
        }
        return reindexingTask.getName();
    }

    public int getTaskQueueLength() {
        IndexTaskQueue queue = this.indexManager.getTaskQueue();
        return queue.getSize();
    }

    public Date getLastStarted() {
        FlushStatistics flushStatistics = this.indexManager.getLastNonEmptyFlushStats();
        if (flushStatistics == null) {
            return null;
        }
        return flushStatistics.getStarted();
    }

    public long getLastElapsedMilliseconds() {
        FlushStatistics flushStatistics = this.indexManager.getLastNonEmptyFlushStats();
        if (flushStatistics == null) {
            return -1L;
        }
        return flushStatistics.getElapsedMilliseconds();
    }

    public boolean getLastWasRecreated() {
        FlushStatistics flushStatistics = this.indexManager.getLastNonEmptyFlushStats();
        return flushStatistics != null && flushStatistics.wasRecreated();
    }

    public boolean getLastWasOptimised() {
        FlushStatistics flushStatistics = this.indexManager.getLastNonEmptyFlushStats();
        return flushStatistics != null && flushStatistics.wasOptimised();
    }
}

