/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.jmx;

import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.server.impl.SMTPMailServerImpl;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.NamingException;

public class JmxSMTPMailServer
extends SMTPMailServerImpl {
    private AtomicInteger emailsSent = new AtomicInteger(0);
    private AtomicInteger emailsAttempted = new AtomicInteger(0);
    private volatile Date lastSuccessful = null;

    public JmxSMTPMailServer() {
    }

    public JmxSMTPMailServer(Long id, String name, String description, String from, String prefix, boolean isSession, String location, String username, String password) {
        super(id, name, description, from, prefix, isSession, location, username, password);
    }

    public JmxSMTPMailServer(Long id, String name, String description, String from, String prefix, boolean isSession, String location, String username, String password, String smtpPort) {
        super(id, name, description, from, prefix, isSession, location, username, password, smtpPort);
    }

    public JmxSMTPMailServer(Long id, String name, String description, String from, String prefix, boolean isSession, boolean removePrecedence, String location, String username, String password, String smtpPort) {
        super(id, name, description, from, prefix, isSession, removePrecedence, location, username, password, smtpPort);
    }

    public void quietSend(Email email) throws MailException {
        this.emailsAttempted.incrementAndGet();
        super.quietSend(email);
        this.lastSuccessful = new Date();
        this.emailsSent.incrementAndGet();
    }

    public void send(Email email) throws MailException {
        this.emailsAttempted.incrementAndGet();
        super.send(email);
        this.lastSuccessful = new Date();
        this.emailsSent.incrementAndGet();
    }

    public int getEmailsSent() {
        return this.emailsSent.intValue();
    }

    public int getEmailsAttempted() {
        return this.emailsAttempted.intValue();
    }

    public Date getLastSuccessful() {
        return this.lastSuccessful;
    }

    public boolean isActive() {
        try {
            super.getSession();
            return true;
        }
        catch (NamingException e1) {
            return false;
        }
        catch (MailException e2) {
            return false;
        }
    }
}

