/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.jmx;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.quartz.JobExecutionContext;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

public class JmxScheduledTaskWrapper {
    private Scheduler scheduler;

    public JmxScheduledTaskWrapper(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public List getCurrentlyRunningJobNames() {
        try {
            List current = this.scheduler.getCurrentlyExecutingJobs();
            ArrayList names = new ArrayList();
            for (JobExecutionContext job : current) {
                current.add(job.getJobDetail().getFullName());
            }
            return names;
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Unable to retrieve currentlyRunningJobs due to : " + e.getMessage());
        }
    }

    public String[] getAllJobNames() {
        try {
            ArrayList<String> niceJobsAsString = new ArrayList<String>();
            HashMap jobGroups = new HashMap();
            String[] groups = this.scheduler.getJobGroupNames();
            for (int x = 0; x < groups.length; ++x) {
                ArrayList<JobInfo> jobs = new ArrayList<JobInfo>();
                jobGroups.put(groups[x], jobs);
                String[] jobNames = this.scheduler.getJobNames(groups[x]);
                for (int y = 0; y < jobNames.length; ++y) {
                    Trigger[] triggers = this.scheduler.getTriggersOfJob(jobNames[y], groups[x]);
                    Date nextExecution = null;
                    Date lastExecution = null;
                    if (triggers != null && triggers.length > 0) {
                        for (int t = 0; t < triggers.length; ++t) {
                            nextExecution = triggers[t].getNextFireTime();
                            lastExecution = triggers[t].getPreviousFireTime();
                            if (nextExecution != null) break;
                        }
                    }
                    jobs.add(new JobInfo(jobNames[y], lastExecution, nextExecution));
                }
            }
            for (Map.Entry o : jobGroups.entrySet()) {
                ArrayList jobsForGroup = (ArrayList)o.getValue();
                for (JobInfo info : jobsForGroup) {
                    String currentJobInfo = "Group : " + o.getKey() + " | Job Name : " + info.getName() + " | Last ran : " + info.getLastExecution();
                    niceJobsAsString.add(currentJobInfo);
                }
            }
            return niceJobsAsString.toArray(new String[niceJobsAsString.size()]);
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Unable to retrieve currentlyRunningJobs due to : " + e.getMessage());
        }
    }

    private Object[] getJobNames(List current) {
        ArrayList<String> jobInfo = new ArrayList<String>();
        for (JobExecutionContext jobExecutionContext : current) {
            jobInfo.add(jobExecutionContext.getJobDetail().getFullName());
        }
        return jobInfo.toArray();
    }

    private static class JobInfo {
        private final String name;
        private final Date nextExecution;
        private final Date lastExecution;

        public JobInfo(String name, Date lastExecution, Date nextExecution) {
            this.name = name;
            this.nextExecution = nextExecution == null ? null : new Date(nextExecution.getTime());
            this.lastExecution = lastExecution == null ? null : new Date(lastExecution.getTime());
        }

        public String getName() {
            return this.name;
        }

        public Date getNextExecution() {
            return this.nextExecution;
        }

        public Date getLastExecution() {
            return this.lastExecution;
        }
    }
}

