/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.jmx;

import com.atlassian.confluence.jmx.MBeanExporterWithUnregister;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.springframework.jmx.export.MBeanExportException;
import org.springframework.jmx.export.MBeanExporter;

public class MBeanExporterWithUnregisterImpl
extends MBeanExporter
implements MBeanExporterWithUnregister {
    private boolean enabled;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void afterPropertiesSet() {
        if (this.enabled) {
            if (this.bailIfResin()) {
                return;
            }
            super.afterPropertiesSet();
        }
    }

    private boolean bailIfResin() {
        try {
            Class.forName("com.caucho.jmx.MBeanServerImpl");
            if (System.getProperty("java.runtime.version").indexOf("1.4") >= 0) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public void unregisterBean(String name) {
        if (!this.enabled || this.server == null) {
            return;
        }
        try {
            this.server.unregisterMBean(new ObjectName(name));
        }
        catch (InstanceNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (MBeanRegistrationException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public void registerManagedResource(Object o, ObjectName objectName) throws MBeanExportException {
        if (!this.enabled || this.server == null) {
            return;
        }
        if (this.bailIfResin()) {
            return;
        }
        super.registerManagedResource(o, objectName);
    }
}

