/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.labels;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.event.events.label.LabelAddEvent;
import com.atlassian.confluence.event.events.label.LabelCreateEvent;
import com.atlassian.confluence.event.events.label.LabelDeleteEvent;
import com.atlassian.confluence.event.events.label.LabelRemoveEvent;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.Labelling;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.labels.ParsedLabelName;
import com.atlassian.confluence.labels.persistence.dao.LabelDao;
import com.atlassian.confluence.labels.persistence.dao.LabelSearchResult;
import com.atlassian.confluence.labels.persistence.dao.RankedLabelSearchResult;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;

public class DefaultLabelManager
implements LabelManager {
    private static float[] bucketBorders = new float[]{0.01f, 0.2f, 0.3f, 0.4f, 0.5f, 0.6f, 0.7f, 0.8f, 0.9f};
    private LabelDao dao;
    private EventManager eventManager;
    private ConfluenceIndexer indexer;

    public void setLabelDao(LabelDao dao) {
        this.dao = dao;
    }

    public void setEventManager(EventManager manager) {
        this.eventManager = manager;
    }

    public void setIndexer(ConfluenceIndexer indexer) {
        this.indexer = indexer;
    }

    public int addLabel(ContentEntityObject content, Label label) {
        boolean labelCreated = false;
        if (!label.isPersistent()) {
            Label persistentLabel = this.dao.findByLabel(label);
            if (persistentLabel == null) {
                this.dao.save(label);
                labelCreated = true;
                this.eventManager.publishEvent((Event)new LabelCreateEvent(label));
            } else {
                label = persistentLabel;
            }
        }
        if (this.dao.findLabellingByContentAndLabel(content, label) != null) {
            return 0;
        }
        String spaceKey = content instanceof SpaceContentEntityObject ? ((SpaceContentEntityObject)content).getSpaceKey() : null;
        String userName = AuthenticatedUserThreadLocal.getUser() != null ? AuthenticatedUserThreadLocal.getUser().getName() : null;
        Labelling labelling = new Labelling(label, content, userName, spaceKey);
        content.addLabelling(labelling);
        labelling.setCreationDate(this.now());
        labelling.setLastModificationDate(this.now());
        this.indexSearchableObject(content);
        this.eventManager.publishEvent((Event)new LabelAddEvent(label, content));
        if (labelCreated) {
            return 2;
        }
        return 1;
    }

    private Date now() {
        return Calendar.getInstance().getTime();
    }

    private int internalRemove(ContentEntityObject content, Label label, boolean deleteIfUnused) {
        Label persistentLabel = this.dao.findByLabel(label);
        if (persistentLabel == null) {
            return 0;
        }
        label = persistentLabel;
        Labelling labelling = this.dao.findLabellingByContentAndLabel(content, label);
        if (labelling == null) {
            return 0;
        }
        content.removeLabelling(labelling);
        this.dao.remove(labelling);
        this.indexSearchableObject(content);
        this.eventManager.publishEvent((Event)new LabelRemoveEvent(label, content));
        if (deleteIfUnused && this.getContentCount(label) == 0) {
            this.internalDelete(label);
            return 4;
        }
        return 3;
    }

    public int removeLabel(ContentEntityObject content, Label label) {
        return this.internalRemove(content, label, true);
    }

    public void removeLabels(ContentEntityObject content, List labels) {
        Iterator i = labels.iterator();
        while (i.hasNext()) {
            this.internalRemove(content, (Label)i.next(), true);
        }
    }

    public void removeAllLabels(ContentEntityObject content) {
        if (content != null) {
            Iterator labels = new LinkedList(content.getLabels()).iterator();
            while (labels.hasNext()) {
                this.internalRemove(content, (Label)labels.next(), true);
            }
        }
    }

    public Label getLabel(long id) {
        return this.dao.findById(id);
    }

    public List getSuggestedLabels(ContentEntityObject content) {
        return this.getSuggestedLabels(content, 100);
    }

    public List getSuggestedLabels(ContentEntityObject content, int count) {
        return this.dao.findBySingleDegreeSeparation(content, count);
    }

    public List getSuggestedLabelsInSpace(ContentEntityObject content, String spaceKey) {
        return this.getSuggestedLabelsInSpace(content, spaceKey, 100);
    }

    public List getSuggestedLabelsInSpace(ContentEntityObject content, String spaceKey, int maxResults) {
        return this.dao.findBySingleDegreeSeparation(content, spaceKey, maxResults);
    }

    public List getRelatedLabels(Label label) {
        return this.getRelatedLabels(label, 100);
    }

    public List getRelatedLabels(Label label, int count) {
        if (!label.isPersistent()) {
            label = this.dao.findByLabel(label);
        }
        return this.dao.findBySingleDegreeSeparation(label, count);
    }

    public List getRelatedLabels(List labels, String spaceKey, int maxResultsPerLabel) {
        HashSet labelSet = new HashSet();
        for (Label label : labels) {
            List relatedLabels = StringUtils.isBlank((String)spaceKey) ? this.getRelatedLabels(label, maxResultsPerLabel) : this.getRelatedLabelsInSpace(label, spaceKey, maxResultsPerLabel);
            labelSet.addAll(relatedLabels);
        }
        labelSet.removeAll(labels);
        return new ArrayList(labelSet);
    }

    public List getRelatedLabelsInSpace(Label label, String spaceKey) {
        return this.getRelatedLabelsInSpace(label, spaceKey, 100);
    }

    public List getRelatedLabelsInSpace(Label label, String spaceKey, int maxResults) {
        if (!label.isPersistent()) {
            label = this.dao.findByLabel(label);
        }
        return this.dao.findBySingleDegreeSeparation(label, spaceKey, maxResults);
    }

    public List getSpacesContainingContentWithLabel(Label label) {
        if (!label.isPersistent()) {
            label = this.dao.findByLabel(label);
        }
        return this.dao.findSpacesContainingContentWithLabel(label);
    }

    public List getUsersLabels(String name) {
        return this.dao.findByDetails(null, Namespace.PERSONAL.toString(), name);
    }

    public List getTeamLabels() {
        return this.dao.findByDetails(null, Namespace.TEAM.toString(), null);
    }

    public List getTeamLabelsForSpace(String spaceKey) {
        return this.dao.findByDetailsInSpace(null, Namespace.TEAM.toString(), null, spaceKey);
    }

    public List getRecentlyUsedLabelsInSpace(String key) {
        return this.getRecentlyUsedLabelsInSpace(key, 100);
    }

    public List getRecentlyUsedLabelsInSpace(String key, int maxResults) {
        return this.distinct(this.dao.findRecentlyUsedBySpace(key, maxResults));
    }

    public List getRecentlyUsedLabels(int maxResults) {
        return this.distinct(this.dao.findRecentlyUsed(maxResults));
    }

    public List getRecentlyUsedLabels() {
        return this.getRecentlyUsedLabels(100);
    }

    public List getRecentlyUsedPersonalLabels(String username) {
        return this.getRecentlyUsedPersonalLabels(username, 100);
    }

    public List getRecentlyUsedPersonalLabels(String username, int maxResults) {
        return this.dao.findRecentlyUsedUserLabels(username, maxResults);
    }

    public List getRecentlyUsedPersonalLabellings(String username, int maxResults) {
        return this.dao.findRecentlyUsedUserLabellings(username, maxResults);
    }

    public List getCurrentContentForLabel(Label label) {
        if (!label.isPersistent()) {
            label = this.dao.findByLabel(label);
        }
        return this.dao.findCurrentContentForLabel(label);
    }

    public List getCurrentContentForLabelAndSpace(Label label, String spaceKey) {
        if (!label.isPersistent()) {
            label = this.dao.findByLabel(label);
        }
        return this.dao.findCurrentContentForLabelAndSpace(label, spaceKey);
    }

    public List getCurrentContentWithPersonalLabel(String username) {
        return this.dao.findAllUserLabelledContent(username);
    }

    public List getSpacesWithLabel(Label label) {
        if (!label.isPersistent()) {
            label = this.dao.findByLabel(label);
        }
        return this.dao.findSpacesWithLabel(label);
    }

    public boolean deleteLabel(long id) {
        return this.deleteLabel(this.getLabel(id));
    }

    public List getFavouriteSpaces(String username) {
        return this.dao.getFavouriteSpaces(username);
    }

    public boolean deleteLabel(Label label) {
        if (label == null) {
            return false;
        }
        if ((label = this.getLabel(label)) == null) {
            return false;
        }
        for (ContentEntityObject content : new LinkedList(this.getContent(label))) {
            this.indexSearchableObject(content);
            this.internalRemove(content, label, false);
        }
        return this.internalDelete(label);
    }

    private boolean internalDelete(Label label) {
        this.dao.remove(label);
        this.eventManager.publishEvent((Event)new LabelDeleteEvent(label));
        return true;
    }

    public Label getLabel(ParsedLabelName parsedLabelName) {
        if (parsedLabelName == null) {
            return null;
        }
        return this.getLabel(parsedLabelName.toLabel());
    }

    public Label getLabel(String unparsedLabelName) {
        return this.getLabel(LabelParser.parse(unparsedLabelName));
    }

    public List getLabels(Collection unparsedLabelNames) {
        ArrayList<Label> labelList = new ArrayList<Label>();
        for (String term : unparsedLabelNames) {
            ParsedLabelName parsedLabelName = LabelParser.parse(term);
            Label label = this.getLabel(parsedLabelName);
            if (label == null) continue;
            labelList.add(label);
        }
        return labelList;
    }

    public Label getLabel(Label label) {
        return this.dao.findByLabel(label);
    }

    public List getLabelsByDetail(String labelName, String namespace, String spaceKey, String owner) {
        return this.dao.findByDetailsInSpace(labelName, namespace, owner, spaceKey);
    }

    public List getLabelsInSpace(String key) {
        return this.dao.findBySpace(key, Namespace.GLOBAL.toString());
    }

    public List getMostPopularLabels() {
        return this.getMostPopularLabels(100);
    }

    public List getMostPopularLabels(int count) {
        return this.dao.findMostPopular(Namespace.GLOBAL.toString(), count);
    }

    public List getMostPopularLabelsInSpace(String key) {
        return this.getMostPopularLabelsInSpace(key, 100);
    }

    public List getMostPopularLabelsInSpace(String key, int count) {
        return this.dao.findMostPopularBySpace(Namespace.GLOBAL.toString(), key, count);
    }

    public Set getMostPopularLabelsWithRanks(Comparator comparator) {
        return this.getMostPopularLabelsWithRanks(100, comparator);
    }

    public Set getMostPopularLabelsWithRanks(int maxResults, Comparator comparator) {
        return this.getRankedLabels(this.getMostPopularLabels(maxResults), comparator);
    }

    public Set getMostPopularLabelsWithRanksInSpace(String key, int maxResults, Comparator comparator) {
        return this.getRankedLabels(this.getMostPopularLabelsInSpace(key, maxResults), comparator);
    }

    private Set getRankedLabels(List popularLabels, Comparator comparator) {
        Map buckets = this.getBuckets(popularLabels);
        TreeSet<RankedLabelSearchResult> results = new TreeSet<RankedLabelSearchResult>(comparator);
        for (Integer bucket : buckets.keySet()) {
            List values = (List)buckets.get(bucket);
            for (LabelSearchResult lsr : values) {
                results.add(new RankedLabelSearchResult(lsr, (int)bucket));
            }
        }
        return results;
    }

    private Map getFreqMap(List popularLabels) {
        TreeMap<Integer, LinkedList<LabelSearchResult>> freqMap = new TreeMap<Integer, LinkedList<LabelSearchResult>>();
        for (LabelSearchResult labelSearchResult : popularLabels) {
            int count = labelSearchResult.getCount();
            LinkedList<LabelSearchResult> values = (LinkedList<LabelSearchResult>)freqMap.get(new Integer(count));
            if (values == null) {
                values = new LinkedList<LabelSearchResult>();
            }
            values.add(labelSearchResult);
            freqMap.put(new Integer(count), values);
        }
        return freqMap;
    }

    private Map getBuckets(List popularLabels) {
        int bucket = 1;
        int cumulativeSum = 0;
        int totalSize = 0;
        Map freqMap = this.getFreqMap(popularLabels);
        for (Integer frequency : freqMap.keySet()) {
            totalSize += frequency.intValue();
        }
        TreeMap buckets = new TreeMap();
        for (Integer currentFreq : freqMap.keySet()) {
            float bucketBorder;
            List freqValues = (List)freqMap.get(currentFreq);
            float currentPosition = (float)(cumulativeSum += currentFreq.intValue()) / (float)totalSize;
            for (int i = 0; i < bucketBorders.length && currentPosition > (bucketBorder = bucketBorders[i]); ++i) {
                bucket = i + 1;
            }
            LinkedList bucketValues = (LinkedList)buckets.get(new Integer(bucket));
            if (bucketValues == null) {
                bucketValues = new LinkedList();
            }
            bucketValues.addAll(freqValues);
            buckets.put(new Integer(bucket), bucketValues);
            bucket = 1;
        }
        return buckets;
    }

    private void indexSearchableObject(Searchable object) {
        this.indexer.reIndex(object);
    }

    private List distinct(List objects) {
        HashMap objectsInDistinctList = new HashMap();
        LinkedList distinct = new LinkedList();
        for (int i = 0; i < objects.size(); ++i) {
            Object o = objects.get(i);
            if (objectsInDistinctList.containsKey(o)) continue;
            distinct.add(o);
            objectsInDistinctList.put(o, o);
        }
        return distinct;
    }

    public List getContent(Label label) {
        return this.getCurrentContentForLabel(label);
    }

    public int getContentCount(Label label) {
        return this.dao.findContentCountForLabel(label);
    }

    public Label createLabel(Label label) {
        this.dao.save(label);
        return label;
    }

    public List getRecentlyUsedLabellings(int maxResults) {
        return this.dao.findRecentlyUsedLabelling(maxResults);
    }

    public List getRecentlyUsedLabellingsInSpace(String spaceKey, int maxResults) {
        return this.dao.findRecentlyUsedLabellingsBySpace(spaceKey, maxResults);
    }
}

