/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.labels;

import com.atlassian.confluence.core.Addressable;
import com.atlassian.confluence.labels.DisplayableLabel;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.core.bean.EntityObject;
import java.io.Serializable;
import java.text.Collator;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Category;

public class Label
extends EntityObject
implements Comparable,
Addressable,
Serializable,
DisplayableLabel {
    public static final Category log = Category.getInstance(Label.class);
    private String name;
    private String owner;
    private Namespace namespace;

    public Label() {
        this(null);
    }

    public Label(String name) {
        this(name, Namespace.GLOBAL);
    }

    public Label(String name, Namespace namespace) {
        this(name, namespace, null);
    }

    public Label(String name, String namespace, String owner) {
        this(name, Namespace.getNamespace(namespace), owner);
    }

    public Label(String name, Namespace namespace, String owner) {
        this.name = name != null ? name.toLowerCase() : name;
        this.namespace = namespace;
        this.owner = owner;
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    public String getOwner() {
        return this.owner;
    }

    private void setOwner(String owner) {
        this.owner = owner;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public String getType() {
        return "label:" + this.getNamespace().toString();
    }

    private void setNamespace(Namespace namespace) {
        this.namespace = namespace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Label label = (Label)o;
        if (this.namespace != null ? !this.namespace.equals(label.namespace) : label.namespace != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(label.name) : label.name != null) {
            return false;
        }
        return !(this.owner != null ? !this.owner.equals(label.owner) : label.owner != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 29 * result + (this.owner != null ? this.owner.hashCode() : 0);
        return result;
    }

    public int compareTo(Object o) {
        Label otherlabel = (Label)o;
        Collator collator = Collator.getInstance();
        int typeComparison = collator.compare(this.getNamespace().toString(), otherlabel.getNamespace().toString());
        if (typeComparison != 0) {
            return typeComparison;
        }
        return collator.compare(this.getName(), otherlabel.getName());
    }

    private Date now() {
        return Calendar.getInstance().getTime();
    }

    public String getRealTitle() {
        return this.getDisplayTitle();
    }

    public String getDisplayTitle() {
        return LabelParser.render(this);
    }

    public boolean isRealTitleSafeForUrl() {
        return GeneralUtil.isSafeTitleForUrl(this.getDisplayTitle());
    }

    public String getUrlPath() {
        if (GeneralUtil.isSafeTitleForUrl(this.getDisplayTitle())) {
            return "/label/" + GeneralUtil.urlEncode(this.getDisplayTitle());
        }
        return "/labels/viewlabel.action?ids=" + this.getId();
    }

    public String getUrlPath(String spaceKey) {
        if (this.isTeamLabel()) {
            return "/homepage.action?spacesSelectedTab=team&selectedTeam=" + GeneralUtil.htmlEncode(GeneralUtil.urlEncode(this.getDisplayTitle()));
        }
        if (StringUtils.isBlank((String)spaceKey)) {
            return this.getUrlPath();
        }
        if (GeneralUtil.isSafeTitleForUrl(this.getDisplayTitle())) {
            return "/label/" + GeneralUtil.urlEncode(spaceKey) + "/" + GeneralUtil.urlEncode(this.getDisplayTitle());
        }
        return "/labels/viewlabel.action?ids=" + this.getId() + "&key=" + GeneralUtil.urlEncode(spaceKey);
    }

    public boolean isNew() {
        return this.getCreationDate().equals(this.getLastModificationDate());
    }

    public boolean isPersistent() {
        return this.getId() != 0L;
    }

    public boolean isVisibleTo(String username) {
        if (this.namespace == null) {
            log.error((Object)("Label " + this.getId() + " has null namespace"));
            return true;
        }
        if ("public".equals(this.namespace.getVisibility())) {
            return true;
        }
        if ("owner".equals(this.namespace.getVisibility())) {
            return username != null && username.equals(this.getOwner());
        }
        return false;
    }

    public String toStringWithOwnerPrefix() {
        return "~" + this.getOwner() + ":" + this.getName();
    }

    public String toString() {
        return this.getDisplayTitle();
    }

    public String toStringWithNamespace() {
        return this.getNamespace().toString() + ":" + this.getName();
    }

    public boolean isTeamLabel() {
        return Namespace.isTeam(this);
    }
}

