/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.labels;

import com.atlassian.confluence.labels.Label;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Namespace
implements Serializable,
Comparable {
    public static final String VISIBILITY_PUBLIC = "public";
    public static final String VISIBILITY_OWNER = "owner";
    public static final String VISIBILITY_SYSTEM = "system";
    public static final Namespace PERSONAL = new Namespace("my", "owner");
    public static final Namespace TEAM = new Namespace("team", "public");
    public static final Namespace GLOBAL = new Namespace("global", "public");
    public static final Namespace SYSTEM = new Namespace("system", "system");
    private static final Map officialNamespaces = new HashMap();
    private final String namespacePrefix;
    private final String visibility;

    public static boolean isPersonal(Label l) {
        return PERSONAL.equals(l.getNamespace());
    }

    public static boolean isTeam(Label l) {
        return TEAM.equals(l.getNamespace());
    }

    public static boolean isGlobal(Label l) {
        return GLOBAL.equals(l.getNamespace());
    }

    public static Namespace getNamespace(String prefix) {
        if (prefix == null) {
            return null;
        }
        Namespace namespace = (Namespace)officialNamespaces.get(prefix);
        return namespace == null ? new Namespace(prefix, VISIBILITY_SYSTEM) : namespace;
    }

    private Namespace(String namespacePrefix, String visibility) {
        this.namespacePrefix = namespacePrefix;
        this.visibility = visibility;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Namespace namespace = (Namespace)o;
        return this.namespacePrefix.equals(namespace.namespacePrefix);
    }

    public int compareTo(Object o) {
        return this.namespacePrefix.compareTo(((Namespace)o).namespacePrefix);
    }

    public String getPrefix() {
        return this.namespacePrefix;
    }

    public String toString() {
        return this.namespacePrefix;
    }

    public int hashCode() {
        return this.namespacePrefix.hashCode();
    }

    public String getVisibility() {
        return this.visibility;
    }

    private Object readResolve() throws ObjectStreamException {
        return Namespace.getNamespace(this.namespacePrefix);
    }

    static {
        officialNamespaces.put("my", PERSONAL);
        officialNamespaces.put("team", TEAM);
        officialNamespaces.put("global", GLOBAL);
        officialNamespaces.put(VISIBILITY_SYSTEM, SYSTEM);
    }
}

