/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.labels;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.util.LabelUtil;
import com.atlassian.user.User;
import java.util.List;
import org.apache.log4j.Category;

public class PermittedLabelView
implements Labelable {
    public static final Category log = Category.getInstance(PermittedLabelView.class);
    private Labelable original;
    private User actingUser;
    private boolean hideSpecialLabels;
    private List visibleLabels = null;

    public PermittedLabelView(Labelable original, User actingUser, boolean hideSpecialLabels) {
        this.original = original;
        this.actingUser = actingUser;
        this.hideSpecialLabels = hideSpecialLabels;
    }

    public List getLabels() {
        return this.getVisibleLabels();
    }

    public int getLabelCount() {
        return this.getVisibleLabels().size();
    }

    public boolean isFavourite(User user) {
        return user != null && (this.hasPersonalLabel("favourite", user) || this.hasPersonalLabel("favorite", user));
    }

    private boolean hasPersonalLabel(String labelName, User user) {
        return this.getVisibleLabels().contains(new Label(labelName, Namespace.PERSONAL, user.getName()));
    }

    private List getVisibleLabels() {
        if (this.visibleLabels == null) {
            List originalLabels = this.original.getLabels();
            this.visibleLabels = LabelUtil.getLabelFilters(this.actingUser, this.hideSpecialLabels).filterList(originalLabels);
        }
        return this.visibleLabels;
    }

    public Labelable getDelegate() {
        return this.original;
    }
}

