/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.labels.actions;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.LabelPermissionSupport;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.labels.ParsedLabelName;
import com.atlassian.confluence.labels.actions.AbstractLabelEntityBean;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.security.ImplementsIsPermitted;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.LabelUtil;
import com.atlassian.confluence.util.ajax.AjaxResponse;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AddLabelToEntityBean
extends AbstractLabelEntityBean
implements ImplementsIsPermitted {
    private PageManager pageManager;
    private PermissionManager permissionManager;
    private LabelManager labelManager;

    public void addFavourite(String entityIdString) {
        long entityId = Long.parseLong(entityIdString);
        AbstractPage entity = this.pageManager.getAbstractPage(entityId);
        this.labelManager.addLabel(entity, new Label("favourite", Namespace.PERSONAL, AuthenticatedUserThreadLocal.getUsername()));
    }

    public AjaxResponse addLabel(String entityIdString, String labelString) throws Exception {
        long entityId = Long.parseLong(entityIdString);
        AbstractPage entity = this.pageManager.getAbstractPage(entityId);
        if (entity == null) {
            return AjaxResponse.failure(this.getText("no.page.found.for.id", new Object[]{"'" + entityIdString + "'"}));
        }
        if (StringUtils.isBlank((String)labelString)) {
            return AjaxResponse.failure(this.getText("please.enter.a.label"));
        }
        List labelNames = LabelUtil.split(labelString.toLowerCase());
        if (labelNames.size() > 20) {
            return AjaxResponse.failure(this.getText("labels.too.many.entries", new Object[]{labelNames.size(), 20}));
        }
        if (labelNames.size() + entity.getLabelCount() > 500) {
            return AjaxResponse.failure(this.getText("labels.over.max", new Object[]{labelNames.size() + entity.getLabelCount(), 500}));
        }
        User user = AuthenticatedUserThreadLocal.getUser();
        for (String label : labelNames) {
            ParsedLabelName ref = LabelParser.parse(label);
            if (ref == null) {
                return AjaxResponse.failure(this.getText("label.contains.invalid.chars", new Object[]{label, LabelParser.getInvalidCharactersAsString()}));
            }
            if (!LabelParser.isValidNameLength(ref)) {
                return AjaxResponse.failure(this.getText("label.name.is.too.long", new Object[]{255}));
            }
            if (!LabelParser.isValidPrefixLength(ref)) {
                return AjaxResponse.failure(this.getText("label.prefix.is.too.long", new Object[]{255}));
            }
            if (LabelPermissionSupport.userCanEditLabel(ref, (Labelable)entity, this.permissionManager)) continue;
            return AjaxResponse.failure(this.getText(user == null ? "not.permitted.to.add.labels" : "only.personal.labels.permitted"));
        }
        ArrayList<Label> addedLabels = new ArrayList<Label>();
        for (String labelName : labelNames) {
            Label label = LabelUtil.addLabel(labelName, this.labelManager, entity);
            if (label == null) continue;
            addedLabels.add(label);
        }
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.put("action", this);
        contextMap.put("labels", addedLabels);
        return AjaxResponse.success(VelocityUtils.getRenderedTemplate("labels/labels-list.vm", contextMap));
    }

    public boolean isPersonalLabel(Label label) {
        User user = AuthenticatedUserThreadLocal.getUser();
        return user != null && Namespace.isPersonal(label) && TextUtils.noNull((String)label.getOwner()).equals(user.getName());
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    public boolean isPermitted(List parameters) {
        if (parameters.size() != 1) {
            throw new RuntimeException("expected 1 parameter");
        }
        Object entity = parameters.get(0);
        if (!(entity instanceof Labelable)) {
            return false;
        }
        return LabelPermissionSupport.userCanEditLabels((Labelable)entity, this.permissionManager);
    }
}

