/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.labels.actions;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import org.apache.log4j.Logger;

public class AddSpaceToFavouritesAction
extends AbstractSpaceAction {
    private static final Logger log = Logger.getLogger(AddSpaceToFavouritesAction.class);
    private boolean nonBlankResult = false;

    public String execute() throws Exception {
        if (this.getRemoteUser() == null) {
            log.warn((Object)"Anonymous user tried to add a favourite");
            return this.getReturnValue();
        }
        if (this.getSpace().getDescription() == null) {
            SpaceDescription spaceDescription = new SpaceDescription();
            spaceDescription.setSpace(this.space);
            spaceDescription.setContent("");
            this.space.setDescription(spaceDescription);
            this.spaceManager.saveSpace(this.space);
        }
        this.getLabelManager().addLabel(this.getSpace().getDescription(), new Label("favourite", Namespace.PERSONAL, this.getRemoteUser().getName()));
        return this.getReturnValue();
    }

    private String getReturnValue() {
        return this.nonBlankResult ? "success" : "blank";
    }

    public void setNonBlankResult(boolean nonBlankResult) {
        this.nonBlankResult = nonBlankResult;
    }
}

