/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.labels.actions;

import com.atlassian.confluence.labels.actions.AbstractLabelDisplayingAction;
import com.atlassian.confluence.labels.actions.RankedNameComparator;
import com.atlassian.confluence.labels.actions.RankedRankComparator;
import com.opensymphony.xwork.ActionContext;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class RankListLabelsAction
extends AbstractLabelDisplayingAction {
    private List mostPopularLabels;
    private Set results;

    public void setGroupRanks(boolean b) {
        ActionContext.getContext().getSession().put("confluence.labels.heatmap.group.ranks", b);
    }

    public boolean isGroupRanks() {
        Boolean groupRanks = (Boolean)ActionContext.getContext().getSession().get("confluence.labels.heatmap.group.ranks");
        return groupRanks != null && groupRanks != false;
    }

    public String execute() throws Exception {
        Comparator comp = this.isGroupRanks() ? new RankedRankComparator() : new RankedNameComparator();
        this.results = this.space != null ? this.labelManager.getMostPopularLabelsWithRanksInSpace(this.space.getKey(), 200, comp) : this.labelManager.getMostPopularLabelsWithRanks(200, comp);
        return "success";
    }

    public Set getResults() {
        return this.results;
    }

    public List getMostPopularLabels() {
        if (this.mostPopularLabels == null) {
            this.mostPopularLabels = this.space != null ? this.labelManager.getMostPopularLabelsInSpace(this.space.getKey(), 200) : this.labelManager.getMostPopularLabels(200);
        }
        return this.mostPopularLabels;
    }
}

