/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.labels.actions;

import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.actions.AbstractLabelEntityBean;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.LabelUtil;
import com.atlassian.confluence.util.ajax.AjaxResponse;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SuggestedLabelsForEntityBean
extends AbstractLabelEntityBean {
    private static final String TEMPLATE_NAME = "labels/editpage-suggestedlabels.vm";
    private PageManager pageManager;
    private LabelManager labelManager;

    public AjaxResponse viewLabels(String entityIdString) throws Exception {
        AbstractPage entity;
        Map contextMap = MacroUtils.defaultVelocityContext();
        try {
            entity = this.pageManager.getAbstractPage(Long.parseLong(entityIdString));
        }
        catch (NumberFormatException nfe) {
            contextMap.put("suggestedLabels", Collections.EMPTY_LIST);
            return AjaxResponse.success(VelocityUtils.getRenderedTemplate(TEMPLATE_NAME, contextMap));
        }
        if (entity == null) {
            return AjaxResponse.failure(this.getText("no.page.found.for.id", new Object[]{"'" + entityIdString + "'"}));
        }
        List suggestedLabels = LabelUtil.getRecentAndPopularLabelsForEntity(entity, this.labelManager, 20, AuthenticatedUserThreadLocal.getUsername());
        List filteredLabels = LabelUtil.getLabelFilters(AuthenticatedUserThreadLocal.getUser(), true).filterList(suggestedLabels);
        contextMap.put("suggestedLabels", filteredLabels);
        return AjaxResponse.success(VelocityUtils.getRenderedTemplate(TEMPLATE_NAME, contextMap));
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }
}

