/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.labels.persistence.dao.hibernate;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.Labelling;
import com.atlassian.confluence.labels.persistence.dao.LabelDao;
import com.atlassian.confluence.labels.persistence.dao.LabelSearchResult;
import com.atlassian.confluence.util.LabelUtil;
import com.atlassian.core.db.JDBCUtils;
import com.atlassian.hibernate.HibernateObjectDao;
import com.opensymphony.util.TextUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.commons.lang.StringUtils;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class HibernateLabelDao
extends HibernateObjectDao
implements LabelDao {
    private String dialect = null;
    private boolean isDB2 = false;
    private boolean isMySQL = false;
    private boolean forceSQL = false;

    public boolean isDB2() {
        if (this.dialect == null) {
            this.setDialect();
        }
        return this.isDB2;
    }

    public void setForceSQL(boolean forceSQL) {
        this.forceSQL = forceSQL;
    }

    public boolean isMySQL() {
        if (this.dialect == null) {
            this.setDialect();
        }
        return this.isMySQL;
    }

    private void setDialect() {
        this.dialect = BootstrapUtils.getBootstrapManager().getString("hibernate.dialect");
        if (this.dialect != null && this.dialect.indexOf("DB2") != -1) {
            this.isDB2 = true;
        }
        if (this.dialect != null && this.dialect.indexOf("MySQL") != -1) {
            this.isMySQL = true;
        }
    }

    public Class getPersistentClass() {
        return Label.class;
    }

    public Label findById(long id) {
        return (Label)super.getByClassId(id);
    }

    public Label findByLabel(final Label label) {
        String hql = "from Label label ";
        hql = label.getName() != null ? hql + "where label.name = :name " : hql + "where label.name is null ";
        hql = label.getNamespace() != null ? hql + "and label.namespace = :namespace " : hql + "and label.namespace is null ";
        hql = label.getOwner() != null ? hql + "and label.owner = :owner " : hql + "and label.owner is null ";
        final String hqlQuery = hql;
        return (Label)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery(hqlQuery);
                queryObject.setCacheable(true);
                if (label.getName() != null) {
                    queryObject.setString("name", label.getName());
                }
                if (label.getNamespace() != null) {
                    queryObject.setString("namespace", label.getNamespace().toString());
                }
                if (label.getOwner() != null) {
                    queryObject.setString("owner", label.getOwner());
                }
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateLabelDao.this.getSessionFactory());
                List labels = queryObject.list();
                if (labels.size() == 0) {
                    return null;
                }
                if (labels.size() > 1) {
                    log.error((Object)("There is more than one label named '" + label.getName() + "' in the '" + label.getNamespace().toString() + "' namespace."));
                }
                return labels.get(0);
            }
        });
    }

    public List findByDetails(String name, String namespace, String owner) {
        return this.findByDetailsInSpace(name, namespace, owner, null);
    }

    public List findByDetailsInSpace(final String name, final String namespace, final String owner, final String spaceKey) {
        String hql = "select distinct l from Label l ";
        String sep = " where ";
        if (TextUtils.stringSet((String)spaceKey)) {
            hql = hql + ", Labelling as lc";
            hql = hql + sep + " lower(lc.spaceKey) = :spaceKey ";
            sep = "and";
            hql = hql + sep + " lc.label = l ";
        }
        if (TextUtils.stringSet((String)name)) {
            hql = hql + sep + " l.name = :name ";
            sep = "and";
        }
        if (TextUtils.stringSet((String)namespace)) {
            hql = hql + sep + " l.namespace = :namespace ";
            sep = "and";
        }
        if (TextUtils.stringSet((String)owner)) {
            hql = hql + sep + " l.owner = :owner ";
        }
        final String hqlQuery = hql = hql + "order by l.name";
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery(hqlQuery);
                if (TextUtils.stringSet((String)name)) {
                    queryObject.setString("name", name);
                }
                if (TextUtils.stringSet((String)namespace)) {
                    queryObject.setString("namespace", namespace);
                }
                if (TextUtils.stringSet((String)owner)) {
                    queryObject.setString("owner", owner);
                }
                if (TextUtils.stringSet((String)spaceKey)) {
                    queryObject.setString("spaceKey", spaceKey.toLowerCase());
                }
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateLabelDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
    }

    public List findBySpace(String spaceKey, String namespace) {
        return this.findByDetailsInSpace(null, namespace, null, spaceKey);
    }

    public List findRecentlyUsedBySpace(String spaceKey, int maxResults) {
        return LabelUtil.extractLabelsFromLabellings(this.findRecentlyUsedLabellingsBySpace(spaceKey, maxResults));
    }

    public List findRecentlyUsed(int maxResults) {
        return LabelUtil.extractLabelsFromLabellings(this.findRecentlyUsedLabelling(maxResults));
    }

    public List findRecentlyUsedLabelling(int maxResults) {
        if (maxResults != 0) {
            return this.findNamedQuery("confluence.labelling_findRecentlyUsed", false, maxResults);
        }
        return this.findNamedQuery("confluence.labelling_findRecentlyUsed", false);
    }

    public List findRecentlyUsedLabellingsBySpace(String spaceKey, int maxResults) {
        if (maxResults != 0) {
            return this.findNamedQueryStringParam("confluence.labelling_findRecentlyUsedBySpace", "spaceKey", this.lowerCaseIfNotNull(spaceKey), false, maxResults);
        }
        return this.findNamedQueryStringParam("confluence.labelling_findRecentlyUsedBySpace", "spaceKey", this.lowerCaseIfNotNull(spaceKey), false);
    }

    public List findRecentlyUsedUserLabels(String username, int maxResults) {
        return LabelUtil.extractLabelsFromLabellings(this.findRecentlyUsedUserLabellings(username, maxResults));
    }

    public List findRecentlyUsedUserLabellings(String username, int maxResults) {
        if (maxResults != 0) {
            return this.findNamedQueryStringParam("confluence.labelling_findRecentlyUsedUserLabels", "username", username, false, maxResults);
        }
        return this.findNamedQueryStringParam("confluence.labelling_findRecentlyUsedUserLabels", "username", username, false);
    }

    public List findMostPopular(String namespace, int maxResults) {
        if (this.forceSQL || this.isMySQL()) {
            return this.executeLabelSearch("SELECT count(lc.LABELID) as labelCount, lc.LABELID as labelId  FROM CONTENT_LABEL lc, LABEL l, CONTENT c WHERE lc.LABELID = l.LABELID AND c.CONTENTID = lc.CONTENTID AND l.NAMESPACE = ? And c.CONTENT_STATUS<>'deleted' GROUP BY lc.LABELID ORDER BY labelCount DESC", new String[]{namespace}, maxResults);
        }
        return this.performNonMySqlMostPopular(namespace, maxResults);
    }

    private List performNonMySqlMostPopular(String namespace, int maxResults) {
        if (maxResults != 0) {
            return this.createListOfLabelSearchResults(this.findNamedQueryStringParam("confluence.labelling_findMostPopular", "namespace", namespace, true, maxResults));
        }
        return this.createListOfLabelSearchResults(this.findNamedQueryStringParam("confluence.labelling_findMostPopular", "namespace", namespace, true));
    }

    private List createListOfLabelSearchResults(List labels) {
        ArrayList<LabelSearchResult> results = new ArrayList<LabelSearchResult>(labels.size());
        for (Object[] labelCount : labels) {
            results.add(new LabelSearchResult((Label)labelCount[0], (Integer)labelCount[1]));
        }
        return results;
    }

    public List findMostPopularBySpace(String namespace, String spaceKey, int maxResults) {
        if (this.forceSQL || this.isMySQL()) {
            return this.executeLabelSearch("SELECT count(lc.LABELID) as labelCount, lc.LABELID as labelId  FROM CONTENT_LABEL lc, LABEL l, CONTENT c WHERE lc.SPACEKEY = ? AND lc.LABELID = l.LABELID AND c.CONTENTID = lc.CONTENTID AND l.NAMESPACE = ? And c.CONTENT_STATUS<>'deleted' GROUP BY lc.LABELID ORDER BY labelCount DESC", new String[]{spaceKey, namespace}, maxResults);
        }
        return this.findNonMySqlPopularBySpace(namespace, spaceKey, maxResults);
    }

    private List findNonMySqlPopularBySpace(String namespace, String spaceKey, int maxResults) {
        if (maxResults != 0) {
            return this.createListOfLabelSearchResults(this.findNamedQueryStringParams("confluence.labelling_findMostPopularBySpace", "namespace", namespace, "spaceKey", this.lowerCaseIfNotNull(spaceKey), true, maxResults));
        }
        return this.createListOfLabelSearchResults(this.findNamedQueryStringParams("confluence.labelling_findMostPopularBySpace", "namespace", namespace, "spaceKey", this.lowerCaseIfNotNull(spaceKey), true));
    }

    public List findBySingleDegreeSeparation(ContentEntityObject content, int maxResults) {
        return this.findBySingleDegreeSeparation(content, null, maxResults);
    }

    public List findBySingleDegreeSeparation(ContentEntityObject content, String spaceKey, int maxResults) {
        if (content == null) {
            return Collections.EMPTY_LIST;
        }
        int contentLabelsSize = content.getLabelCount();
        List queryResults = spaceKey != null ? (maxResults != 0 ? (this.isDB2() ? this.findNamedQueryStringParams("confluence.label_findSingleDegreeSeparationFromContentBySpace_db2", "contentID", new Long(content.getId()), "spaceKey", this.lowerCaseIfNotNull(spaceKey), false, maxResults + contentLabelsSize) : this.findNamedQueryStringParams("confluence.label_findSingleDegreeSeparationFromContentBySpace", "contentID", new Long(content.getId()), "spaceKey", this.lowerCaseIfNotNull(spaceKey), false, maxResults + contentLabelsSize)) : this.findNamedQueryStringParams("confluence.label_findSingleDegreeSeparationFromContentBySpace", "contentID", new Long(content.getId()), "spaceKey", this.lowerCaseIfNotNull(spaceKey), false)) : (maxResults != 0 ? (this.isDB2() ? this.findNamedQueryStringParam("confluence.label_findSingleDegreeSeparationFromContent_db2", "contentID", new Long(content.getId()), false, maxResults + contentLabelsSize) : this.findNamedQueryStringParam("confluence.label_findSingleDegreeSeparationFromContent", "contentID", new Long(content.getId()), false, maxResults + contentLabelsSize)) : this.findNamedQueryStringParam("confluence.label_findSingleDegreeSeparationFromContent", "contentID", new Long(content.getId()), false));
        List contentLabelFilteredList = this.filter(content.getLabels(), queryResults);
        if (maxResults != 0 && contentLabelFilteredList.size() > maxResults) {
            return contentLabelFilteredList.subList(0, maxResults);
        }
        return contentLabelFilteredList;
    }

    public List findBySingleDegreeSeparation(Label label, int maxResults) {
        return this.findBySingleDegreeSeparation(label, null, maxResults);
    }

    public List findBySingleDegreeSeparation(Label label, String spaceKey, int maxResults) {
        if (label == null) {
            return Collections.EMPTY_LIST;
        }
        if (!label.isPersistent()) {
            throw new IllegalArgumentException("Please provide a persistent instance of the label.");
        }
        if (spaceKey != null) {
            if (maxResults != 0) {
                if (this.isDB2()) {
                    return this.findNamedQueryStringParams("confluence.label_findSingleDegreeSeparationFromLabelBySpace_db2", "labelID", new Long(label.getId()), "spaceKey", this.lowerCaseIfNotNull(spaceKey), false, maxResults);
                }
                return this.findNamedQueryStringParams("confluence.label_findSingleDegreeSeparationFromLabelBySpace", "labelID", new Long(label.getId()), "spaceKey", this.lowerCaseIfNotNull(spaceKey), false, maxResults);
            }
            return this.findNamedQueryStringParams("confluence.label_findSingleDegreeSeparationFromLabelBySpace", "labelID", new Long(label.getId()), "spaceKey", this.lowerCaseIfNotNull(spaceKey), false);
        }
        if (maxResults != 0) {
            if (this.isDB2()) {
                return this.findNamedQueryStringParam("confluence.label_findSingleDegreeSeparationFromLabel_db2", "labelID", new Long(label.getId()), false, maxResults);
            }
            return this.findNamedQueryStringParam("confluence.label_findSingleDegreeSeparationFromLabel", "labelID", new Long(label.getId()), false, maxResults);
        }
        return this.findNamedQueryStringParam("confluence.label_findSingleDegreeSeparationFromLabel", "labelID", new Long(label.getId()), false);
    }

    public List findContentForLabel(Label label) {
        if (label == null) {
            return Collections.EMPTY_LIST;
        }
        return this.findNamedQueryStringParam("confluence.label_findContentForLabel", "labelID", new Long(label.getId()), false);
    }

    public List findAllUserLabelledContent(final String username) {
        if (username == null) {
            return Collections.EMPTY_LIST;
        }
        return this.distinctContent((List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery("confluence.label_findAllUserLabelledContent");
                queryObject.setParameter("username", (Object)username);
                queryObject.setCacheable(true);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateLabelDao.this.getSessionFactory());
                return queryObject.list();
            }
        }));
    }

    private List distinctContent(List queryResults) {
        HashMap<ContentEntityObject, ContentEntityObject> retrievedContent = new HashMap<ContentEntityObject, ContentEntityObject>();
        Iterator i = queryResults.iterator();
        while (i.hasNext()) {
            ContentEntityObject content = (ContentEntityObject)i.next();
            if (retrievedContent.containsKey(content)) {
                i.remove();
                continue;
            }
            retrievedContent.put(content, content);
        }
        return queryResults;
    }

    public List findCurrentContentForLabel(Label label) {
        if (label == null) {
            return Collections.EMPTY_LIST;
        }
        return this.findNamedQueryStringParam("confluence.label_findContentForLabel", "labelID", new Long(label.getId()), false);
    }

    public int findContentCountForLabel(final Label label) {
        Integer count = (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery("select count(labelling) from Labelling labelling where labelling.label = :label");
                queryObject.setParameter("label", (Object)label);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateLabelDao.this.getSessionFactory());
                Iterator results = queryObject.iterate();
                if (results.hasNext()) {
                    return (Integer)results.next();
                }
                return new Integer(0);
            }
        });
        return count;
    }

    public List findCurrentContentForLabelAndSpace(Label label, String spaceKey) {
        if (label == null) {
            return Collections.EMPTY_LIST;
        }
        if (StringUtils.isBlank((String)spaceKey)) {
            return this.findContentByLabel(label);
        }
        return this.findNamedQueryStringParams("confluence.label_findContentForLabelAndSpace", "labelID", new Long(label.getId()), "spaceKey", this.lowerCaseIfNotNull(spaceKey), false);
    }

    public List findSpacesContainingContentWithLabel(Label label) {
        if (label == null) {
            return Collections.EMPTY_LIST;
        }
        return this.findNamedQueryStringParam("confluence.label_findSpacesContainingContentWithLabel", "labelID", String.valueOf(label.getId()), false);
    }

    public List findSpacesWithLabel(Label label) {
        if (label == null) {
            return Collections.EMPTY_LIST;
        }
        return this.findNamedQueryStringParam("confluence.label_findSpacesWithLabel", "labelID", new Long(label.getId()), false);
    }

    public Labelling findLabellingByContentAndLabel(final ContentEntityObject content, final Label label) {
        return (Labelling)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery("confluence.label_findLabellingByContentAndLabel");
                queryObject.setParameter("contentId", (Object)new Long(content.getId()));
                queryObject.setParameter("labelId", (Object)new Long(label.getId()));
                queryObject.setCacheable(true);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateLabelDao.this.getSessionFactory());
                return queryObject.uniqueResult();
            }
        });
    }

    public Labelling findLabellingById(final long id) {
        return (Labelling)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.load(Labelling.class, (Serializable)new Long(id));
            }
        });
    }

    public void deleteLabellingBySpace(final String key) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                session.flush();
                Connection con = session.connection();
                PreparedStatement ps = null;
                try {
                    ps = con.prepareStatement("delete from CONTENT_LABEL where SPACEKEY = ? ");
                    ps.setString(1, key);
                    ps.execute();
                    Object var4_4 = null;
                    return var4_4;
                }
                finally {
                    JDBCUtils.close((Statement)ps);
                }
            }
        });
    }

    public List getFavouriteSpaces(final String username) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery("confluence.label_findFavouriteSpaces");
                queryObject.setString("owner", username);
                queryObject.setCacheable(false);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateLabelDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
    }

    public List findUnusedLabels() {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery("confluence.label_unused");
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateLabelDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
    }

    private List filter(List labelsToBeRemoved, List listToBeFiltered) {
        HashMap<Label, Label> quickLabelLookup = new HashMap<Label, Label>();
        for (int i = 0; i < labelsToBeRemoved.size(); ++i) {
            Label l = (Label)labelsToBeRemoved.get(i);
            quickLabelLookup.put(l, l);
        }
        LinkedList<Label> filteredResults = new LinkedList<Label>();
        for (int i = 0; i < listToBeFiltered.size(); ++i) {
            Label l = (Label)listToBeFiltered.get(i);
            if (quickLabelLookup.containsKey(l)) continue;
            filteredResults.add(l);
        }
        return filteredResults;
    }

    private List executeLabelSearch(final String query, final String[] args, final int maxResults) {
        List queryResult = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                LinkedList<Count> linkedList;
                PreparedStatement stmt = null;
                ResultSet rs = null;
                try {
                    boolean limitResultSize;
                    stmt = session.connection().prepareStatement(query);
                    for (int i = 0; i < args.length; ++i) {
                        stmt.setString(i + 1, args[i]);
                    }
                    rs = stmt.executeQuery();
                    LinkedList<Count> results = new LinkedList<Count>();
                    boolean bl = limitResultSize = maxResults > 0;
                    while (rs.next() && (!limitResultSize || results.size() < maxResults)) {
                        Count count = new Count();
                        count.count = rs.getInt("labelCount");
                        count.id = rs.getLong("labelId");
                        results.add(count);
                    }
                    linkedList = results;
                }
                catch (SQLException e) {
                    try {
                        throw new HibernateException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        JDBCUtils.close(rs);
                        JDBCUtils.close((Statement)stmt);
                        throw throwable;
                    }
                }
                JDBCUtils.close((ResultSet)rs);
                JDBCUtils.close((Statement)stmt);
                return linkedList;
            }
        });
        LinkedList<LabelSearchResult> results = new LinkedList<LabelSearchResult>();
        for (int i = 0; i < queryResult.size(); ++i) {
            Count c = (Count)queryResult.get(i);
            if (c.count <= 0) continue;
            Label label = (Label)this.getHibernateTemplate().load(this.getPersistentClass(), (Serializable)new Long(c.id));
            results.add(new LabelSearchResult(label, c.count));
        }
        return results;
    }

    private String lowerCaseIfNotNull(String str) {
        if (str == null) {
            return str;
        }
        return str.toLowerCase();
    }

    public List findContentByLabel(Label label) {
        return this.findNamedQueryStringParam("confluence.label_findContentForLabel", "labelID", new Long(label.getId()), false);
    }

    private class Count {
        int count;
        long id;

        private Count() {
        }
    }
}

