/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.links;

import com.atlassian.bonnie.AnyTypeObjectDao;
import com.atlassian.bonnie.Handle;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.links.ReferralLink;
import com.atlassian.confluence.links.ReferralManager;
import com.atlassian.confluence.links.TrackbackLink;
import com.atlassian.confluence.links.persistence.dao.ReferralDao;
import com.atlassian.confluence.links.persistence.dao.TrackbackDao;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.core.db.JDBCUtils;
import com.atlassian.renderer.util.UrlUtil;
import com.atlassian.trackback.Trackback;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class DefaultReferralManager
implements ReferralManager {
    private static Logger log = Logger.getLogger(DefaultReferralManager.class);
    private ReferralDao referralDao;
    private TrackbackDao trackbackDao;
    private SettingsManager settingsManager;
    private SessionFactory sessionFactory;
    private ContentEntityManager contentEntityManager;
    private AnyTypeObjectDao anyTypeObjectDao;
    private static final int MAX_REFERRER_LENGTH = 255;

    public List getHotReferrers(ContentEntityObject content, int maxCount) {
        return this.referralDao.findHotReferrers(content.getId(), maxCount, this.settingsManager.getGlobalSettings().getReferrerSettings().getExcludedReferrers());
    }

    public void saveReferralLink(ReferralLink link) {
        link.getSourceContent().addReferralLink(link);
        this.referralDao.save(link);
    }

    public void saveTrackback(Trackback tb, long entityId) {
        if (!this.settingsManager.getGlobalSettings().isAllowTrackbacks()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Skipping saveTrackback() since trackbacks have been disabled.");
            }
            return;
        }
        if (tb == null) {
            log.warn((Object)("Trackback for Entity with id " + entityId + " is null. Unable to save trackback"));
            return;
        }
        String trackbackUrl = tb.getUrl();
        if (StringUtils.isBlank((String)trackbackUrl)) {
            log.warn((Object)("Trackback for Entity with id " + entityId + " has no URL. Unable to save trackback"));
            return;
        }
        ContentEntityObject entity = this.contentEntityManager.getById(entityId);
        if (entity == null) {
            log.warn((Object)("Entity with id " + entityId + " does not exist. Unable to save trackback"));
            return;
        }
        TrackbackLink trackbackLink = this.getExistingTrackbackLink(entity, trackbackUrl);
        if (trackbackLink == null) {
            trackbackLink = new TrackbackLink();
            trackbackLink.setUrl(trackbackUrl);
            entity.addTrackbackLink(trackbackLink);
        }
        trackbackLink.setBlogName(tb.getBlogName());
        trackbackLink.setTitle(tb.getTitle());
        trackbackLink.setExcerpt(tb.getExcerpt());
        trackbackLink.setSourceContent(entity);
        this.trackbackDao.save(trackbackLink);
    }

    private TrackbackLink getExistingTrackbackLink(ContentEntityObject entity, String trackbackUrl) {
        for (TrackbackLink existingTrackbackLink : entity.getTrackbackLinks()) {
            if (!trackbackUrl.equals(existingTrackbackLink.getUrl())) continue;
            return existingTrackbackLink;
        }
        return null;
    }

    public void referToContent(Handle handle, String referrer, int hitCount) {
        if (referrer == null || hitCount == 0) {
            log.warn((Object)"Null referrer or zero hit count was recorded");
            return;
        }
        if (StringUtils.isBlank((String)(referrer = referrer.trim())) || UrlUtil.getUrlIndex((String)referrer) != 0 || referrer.length() > 255) {
            log.info((Object)("Referrer isn't a valid URL: " + referrer));
            return;
        }
        if (handle == null) {
            log.info((Object)("Handle is null for referrer URL: " + referrer));
            return;
        }
        Object content = this.anyTypeObjectDao.findByHandle(handle);
        if (content == null) {
            return;
        }
        if (!(content instanceof ContentEntityObject)) {
            log.warn((Object)("Can not store referrers for non-ContentEntityObjects: " + content));
            return;
        }
        if (this.isReferringRequest(referrer)) {
            this.addReferralLinkForUrl((ContentEntityObject)content, referrer, hitCount);
        }
    }

    private boolean isReferringRequest(String referer) {
        if (referer == null || referer.startsWith(this.settingsManager.getGlobalSettings().getBaseUrl())) {
            return false;
        }
        List excludedReferrers = this.settingsManager.getGlobalSettings().getReferrerSettings().getExcludedReferrers();
        for (String excludedPrefix : excludedReferrers) {
            if (!referer.startsWith(excludedPrefix)) continue;
            return false;
        }
        return true;
    }

    private void addReferralLinkForUrl(ContentEntityObject content, String url, int hitCount) {
        ReferralLink referralLink = this.referralDao.findReferralLink(content.getId(), url);
        if (referralLink == null) {
            referralLink = new ReferralLink();
            referralLink.setSourceContent(content);
            referralLink.setUrl(url);
            content.addReferralLink(referralLink);
        }
        referralLink.setViewCount(referralLink.getViewCount() + hitCount);
        this.referralDao.save(referralLink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int deleteReferrersWithPrefix(String prefix) {
        Session session = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
        int totalLinksPurged = 0;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Connection c = session.connection();
            String mysql = "select count(*) from EXTRNLNKS where URL LIKE '" + prefix + "%'";
            ps = c.prepareStatement(mysql);
            rs = ps.executeQuery();
            rs.next();
            totalLinksPurged = rs.getInt(1);
            mysql = "delete from EXTRNLNKS where URL LIKE '" + prefix + "%'";
            ps = c.prepareStatement(mysql);
            ps.execute();
            this.sessionFactory.evictQueries();
            this.sessionFactory.evict(ReferralLink.class);
        }
        catch (HibernateException e) {
            log.error((Object)("Can't delete referrer with prefix: " + prefix), (Throwable)e);
            JDBCUtils.close(rs);
            JDBCUtils.close((Statement)ps);
        }
        catch (SQLException e2) {
            log.error((Object)("Can't delete referrer with prefix: " + prefix), (Throwable)e2);
            {
                catch (Throwable throwable) {
                    JDBCUtils.close(rs);
                    JDBCUtils.close(ps);
                    throw throwable;
                }
            }
            JDBCUtils.close(rs);
            JDBCUtils.close((Statement)ps);
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((Statement)ps);
        return totalLinksPurged;
    }

    public void setReferralDao(ReferralDao referralDao) {
        this.referralDao = referralDao;
    }

    public void setTrackbackDao(TrackbackDao trackbackDao) {
        this.trackbackDao = trackbackDao;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }

    public void setAnyTypeObjectDao(AnyTypeObjectDao anyTypeObjectDao) {
        this.anyTypeObjectDao = anyTypeObjectDao;
    }
}

