/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.links;

import com.atlassian.bonnie.Handle;
import com.atlassian.confluence.links.ReferralManager;
import com.atlassian.core.task.Task;

public class ReferralTask
implements Task {
    private Handle entityHandle;
    private String referrerUrl;
    private int hitCount = 1;
    private ReferralManager referralManager;

    public ReferralTask(Handle entityHandle, String referrerUrl) {
        this.entityHandle = entityHandle;
        this.referrerUrl = referrerUrl;
    }

    public void execute() throws Exception {
        this.referralManager.referToContent(this.entityHandle, this.referrerUrl, this.hitCount);
    }

    public void setReferralManager(ReferralManager referralManager) {
        this.referralManager = referralManager;
    }

    public void incrementHitCount() {
        ++this.hitCount;
    }

    public String getReferrerUrl() {
        return this.referrerUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReferralTask)) {
            return false;
        }
        ReferralTask referralTask = (ReferralTask)o;
        if (this.hitCount != referralTask.hitCount) {
            return false;
        }
        if (this.entityHandle != null ? !this.entityHandle.equals(referralTask.entityHandle) : referralTask.entityHandle != null) {
            return false;
        }
        return !(this.referrerUrl != null ? !this.referrerUrl.equals(referralTask.referrerUrl) : referralTask.referrerUrl != null);
    }

    public int hashCode() {
        int result = this.entityHandle != null ? this.entityHandle.hashCode() : 0;
        result = 29 * result + (this.referrerUrl != null ? this.referrerUrl.hashCode() : 0);
        result = 29 * result + this.hitCount;
        return result;
    }
}

