/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.links.linktypes;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.links.linktypes.AbstractPageLink;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.renderer.links.GenericLinkParser;
import com.opensymphony.util.TextUtils;
import java.text.ParseException;

public class PageLink
extends AbstractPageLink {
    public static PageLink makeTestLink(String linkText, PageContext context) throws ParseException {
        GenericLinkParser parser = new GenericLinkParser(linkText);
        parser.parseAsContentLink();
        return new PageLink(parser, context);
    }

    private PageLink(GenericLinkParser parser, PageContext pageContext) throws ParseException {
        super(parser, pageContext);
        this.destinationPage = new Page();
        this.destinationPage.setTitle(parser.getDestinationTitle() == null ? pageContext.getPageTitle() : parser.getDestinationTitle());
    }

    public PageLink(GenericLinkParser parser, PageContext pageContext, PageManager pageManager) throws ParseException {
        super(parser, pageContext);
        if (!AbstractPage.isValidPageTitle(this.entityName)) {
            throw new ParseException("Invalid page title in link " + this.entityName, 0);
        }
        this.destinationPage = pageManager.getPage(this.spaceKey, this.entityName);
        if (("#" + this.anchor).equals(this.linkBody)) {
            this.linkBody = this.anchor;
        }
        if (this.destinationPage != null) {
            this.setUrlAndTitle(pageContext);
        }
    }

    public boolean isOnSamePage(PageContext pageContext) {
        if (!TextUtils.stringSet((String)pageContext.getPageTitle()) || !TextUtils.stringSet((String)pageContext.getSpaceKey()) || pageContext.getPostingDay() != null) {
            return false;
        }
        return pageContext.getPageTitle().equals(this.destinationPage.getTitle()) && pageContext.getSpaceKey().equals(this.destinationPage.getSpace().getKey());
    }

    public ContentEntityObject getDestinationContent() {
        return this.destinationPage;
    }
}

