/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.links.linktypes;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.links.linktypes.AbstractContentEntityLink;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.renderer.links.GenericLinkParser;
import com.atlassian.renderer.util.RendererProperties;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import java.text.ParseException;
import java.util.Arrays;

public class UserProfileLink
extends AbstractContentEntityLink {
    public static final String USER_ICON = "user";
    public static final String PERSONAL_SPACE_USER_ICON = "personal_space_user";
    private User user;
    private PersonalInformation info;
    private PersonalInformationManager personalInformationManager;

    public UserProfileLink(GenericLinkParser parser, UserAccessor userAccessor) throws ParseException {
        super(parser);
        this.iconName = USER_ICON;
        if (parser.getDestinationTitle().length() == 1) {
            throw new ParseException("No username supplied", 0);
        }
        StringBuffer buf = new StringBuffer(parser.getDestinationTitle().substring(1));
        if (buf.charAt(buf.length() - 1) == '/') {
            buf.deleteCharAt(buf.length() - 1);
        }
        this.user = userAccessor.getUser(buf.toString());
        if (this.user != null) {
            this.info = this.getPersonalInformationManager().getPersonalInformation(this.user);
            if ("true".equals(this.info.getHasPersonalSpace().toLowerCase())) {
                this.iconName = PERSONAL_SPACE_USER_ICON;
            }
            this.url = GeneralUtil.isAllAscii(this.user.getName()) ? "/display/~" + GeneralUtil.urlEncode(this.user.getName()) : "/display/~" + GeneralUtil.doubleUrlEncode(this.user.getName());
            this.setI18nTitle(RendererProperties.VIEW_PROFILE, Arrays.asList(this.user.getFullName()));
            if (this.linkBody.equalsIgnoreCase(parser.getDestinationTitle())) {
                this.linkBody = this.user.getFullName();
            }
        }
    }

    public ContentEntityObject getDestinationContent() {
        return this.info;
    }

    public boolean hasDestination() {
        return this.user != null;
    }

    public void setPersonalInformationManager(PersonalInformationManager personalInformationManager) {
        this.personalInformationManager = personalInformationManager;
    }

    public PersonalInformationManager getPersonalInformationManager() {
        if (this.personalInformationManager == null) {
            this.personalInformationManager = (PersonalInformationManager)ContainerManager.getComponent((String)"personalInformationManager");
        }
        return this.personalInformationManager;
    }
}

