/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.links.persistence;

import com.atlassian.confluence.links.ReferralManager;
import com.atlassian.spring.container.ContainerContext;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.trackback.Trackback;
import com.atlassian.trackback.TrackbackStore;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ConfluenceTrackbackStore
implements TrackbackStore {
    private static final Logger log = Logger.getLogger(ConfluenceTrackbackStore.class);
    private static Pattern entityPattern = Pattern.compile("/([0-9]*)");

    public void storeTrackback(Trackback trackback, HttpServletRequest httpServletRequest) {
        String pathInfo = httpServletRequest.getPathInfo();
        long entityId = ConfluenceTrackbackStore.extractEntityId(pathInfo);
        if (entityId == -1L) {
            return;
        }
        ContainerContext ctx = ContainerManager.getInstance().getContainerContext();
        ReferralManager rm = (ReferralManager)ctx.getComponent((Object)"referralManager");
        rm.saveTrackback(trackback, entityId);
    }

    static long extractEntityId(String pathInfo) {
        if (pathInfo == null) {
            log.debug((Object)"Path info for trackback request is null");
            return -1L;
        }
        Matcher m = entityPattern.matcher(pathInfo);
        String id = "";
        if (m.find()) {
            id = m.group(1);
        }
        if (StringUtils.isBlank((String)id)) {
            log.debug((Object)("No id specified in the trackback:ping URL - " + pathInfo));
            return -1L;
        }
        long entityId = -1L;
        try {
            entityId = Long.parseLong(id);
        }
        catch (NumberFormatException e) {
            log.info((Object)("Invalid ContentEntityObject id (" + id + ") specified in trackback (" + pathInfo + ")."));
            return -1L;
        }
        return entityId;
    }
}

