/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.macro.params;

import com.atlassian.confluence.macro.MacroExecutionContext;
import com.atlassian.confluence.macro.params.Parameter;
import com.atlassian.confluence.macro.params.ParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseParameter
implements Parameter {
    private List<String> paramNames;
    private String defaultValue;

    protected BaseParameter(String name, String defaultValue) {
        this(new String[]{name}, defaultValue);
    }

    protected BaseParameter(String[] names, String defaultValue) {
        this.paramNames = new ArrayList<String>(Arrays.asList(names));
        this.defaultValue = defaultValue;
    }

    protected BaseParameter(List<String> names, String defaultValue) {
        this.paramNames = new ArrayList<String>(names);
        this.defaultValue = defaultValue;
    }

    public final void addParameterAlias(String name) {
        this.paramNames.add(name);
    }

    public final void setParameterNames(String[] names) {
        this.paramNames = new ArrayList<String>(Arrays.asList(names));
    }

    public final void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public final String getDefaultValue() {
        return this.defaultValue;
    }

    protected final String getParameter(Map<String, String> params, List names, String defaultValue) {
        String value = null;
        Iterator i = names.iterator();
        while (i.hasNext() && value == null) {
            String param = (String)i.next();
            value = params.get(param);
        }
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public final String getParameterValue(Map<String, String> params) {
        return this.getParameter(params, this.paramNames, this.defaultValue);
    }

    @Override
    public final Object findValue(MacroExecutionContext ctx) throws ParameterException {
        String paramValue = this.getParameter(ctx.getParams(), this.paramNames, this.defaultValue);
        return this.findObject(paramValue, ctx);
    }

    protected abstract Object findObject(String var1, MacroExecutionContext var2) throws ParameterException;
}

