/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.macro.query.params;

import com.atlassian.confluence.macro.MacroExecutionContext;
import com.atlassian.confluence.macro.query.SearchQueryInterpreter;
import com.atlassian.confluence.macro.query.SearchQueryInterpreterException;
import com.atlassian.confluence.macro.query.params.BooleanQueryFactoryParameter;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.query.ContentTypeQuery;

public class ContentTypeParameter
extends BooleanQueryFactoryParameter {
    private static final String[] DEFAULT_PARAM_NAMES = new String[]{"type"};

    public ContentTypeParameter() {
        this(null);
    }

    public ContentTypeParameter(String defaultValue) {
        super(DEFAULT_PARAM_NAMES, defaultValue);
    }

    protected SearchQueryInterpreter createSearchQueryInterpreter(MacroExecutionContext ctx) {
        return new Interpreter();
    }

    static class Interpreter
    implements SearchQueryInterpreter {
        Interpreter() {
        }

        public SearchQuery createSearchQuery(String value) throws SearchQueryInterpreterException {
            ContentTypeEnum contentType = ContentTypeEnum.get(value);
            if (contentType != null) {
                return new ContentTypeQuery(contentType);
            }
            throw new SearchQueryInterpreterException("'" + value + "' is not a valid content type");
        }
    }
}

