/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.macro.query.params;

import com.atlassian.confluence.macro.MacroExecutionContext;
import com.atlassian.confluence.macro.query.SearchQueryInterpreter;
import com.atlassian.confluence.macro.query.SearchQueryInterpreterException;
import com.atlassian.confluence.macro.query.params.BooleanQueryFactoryParameter;
import com.atlassian.confluence.search.service.SpaceCategoryEnum;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.query.InSpaceQuery;
import com.atlassian.confluence.search.v2.query.SpaceCategoryQuery;

public class SpaceKeyParameter
extends BooleanQueryFactoryParameter {
    private static final String[] DEFAULT_PARAM_NAMES = new String[]{"space", "spaces"};

    public SpaceKeyParameter() {
        this(null);
    }

    public SpaceKeyParameter(String defaultValue) {
        super(DEFAULT_PARAM_NAMES, defaultValue);
    }

    protected SearchQueryInterpreter createSearchQueryInterpreter(MacroExecutionContext ctx) {
        return new Interpreter(ctx);
    }

    static class Interpreter
    implements SearchQueryInterpreter {
        private static final String SELF_SPACE = "@self";
        private static final String PERSONAL_SPACE = "@personal";
        private static final String GLOBAL_SPACE = "@global";
        private static final String FAVORITE_SPACE = "@favorite";
        private static final String FAVOURITE_SPACE = "@favourite";
        private static final String ALL_SPACE = "@all";
        private final MacroExecutionContext ctx;

        private Interpreter(MacroExecutionContext ctx) {
            this.ctx = ctx;
        }

        public SearchQuery createSearchQuery(String value) throws SearchQueryInterpreterException {
            SpaceCategoryEnum category;
            if (value.equals(SELF_SPACE)) {
                String spaceKey = this.ctx.getPageContext().getSpaceKey();
                return new InSpaceQuery(spaceKey);
            }
            if (value.equals(PERSONAL_SPACE)) {
                category = SpaceCategoryEnum.PERSONAL;
            } else if (value.equals(GLOBAL_SPACE)) {
                category = SpaceCategoryEnum.GLOBAL;
            } else if (value.equals(FAVORITE_SPACE) || value.equals(FAVOURITE_SPACE)) {
                category = SpaceCategoryEnum.FAVOURITES;
            } else if (value.equals(ALL_SPACE)) {
                category = SpaceCategoryEnum.ALL;
            } else {
                throw new SearchQueryInterpreterException(value + " is not a valid value for 'space'");
            }
            return new SpaceCategoryQuery(category);
        }
    }
}

