/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.event.events.admin.MailServerCreateEvent;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import com.atlassian.mail.MailException;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.PopMailServer;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.mail.server.managers.AbstractMailServerManager;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ConfluenceMailServerManager
extends AbstractMailServerManager {
    private BandanaManager bandanaManager;
    private EventManager eventManager;

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public MailServer getMailServer(Long id) throws MailException {
        return (MailServer)this.getSmtpMailServerMap().get(id);
    }

    public MailServer getMailServer(String name) throws MailException {
        for (MailServer server : this.getSmtpMailServers()) {
            if (!name.equals(server.getName())) continue;
            return server;
        }
        return null;
    }

    public List getServerNames() throws MailException {
        LinkedList<String> nameList = new LinkedList<String>();
        for (MailServer server : this.getSmtpMailServers()) {
            nameList.add(server.getName());
        }
        return nameList;
    }

    public List getSmtpMailServers() throws MailException {
        return new LinkedList(this.getSmtpMailServerMap().values());
    }

    protected Map getSmtpMailServerMap() {
        Map serverMap = (Map)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "atlassian.confluence.smtp.mail.accounts");
        if (serverMap == null) {
            return new LinkedHashMap();
        }
        return serverMap;
    }

    public List getPopMailServers() throws MailException {
        throw new UnsupportedOperationException("Confluence does not support global POP servers");
    }

    public Long create(MailServer mailServer) throws MailException {
        if (mailServer instanceof SMTPMailServer) {
            Map smtpMailServers = this.getSmtpMailServerMap();
            Long id = new Long(System.currentTimeMillis());
            mailServer.setId(id);
            smtpMailServers.put(id, mailServer);
            this.saveServerMap(smtpMailServers);
            this.eventManager.publishEvent((Event)new MailServerCreateEvent((Object)this, mailServer));
            return id;
        }
        throw new UnsupportedOperationException();
    }

    public void update(MailServer mailServer) throws MailException {
        Map serverMap = this.getSmtpMailServerMap();
        serverMap.put(mailServer.getId(), mailServer);
        this.saveServerMap(serverMap);
    }

    private void saveServerMap(Map serverMap) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "atlassian.confluence.smtp.mail.accounts", (Object)serverMap);
    }

    public void delete(Long mailServerId) throws MailException {
        Map serverMap = this.getSmtpMailServerMap();
        serverMap.remove(mailServerId);
        this.saveServerMap(serverMap);
    }

    public SMTPMailServer getDefaultSMTPMailServer() throws MailException {
        List mailServers = this.getSmtpMailServers();
        if (mailServers.isEmpty()) {
            return null;
        }
        return (SMTPMailServer)mailServers.get(0);
    }

    public PopMailServer getDefaultPopMailServer() throws MailException {
        throw new UnsupportedOperationException("Confluence does not support global POP servers");
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }
}

