/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail;

import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.renderer.util.RendererUtil;
import com.opensymphony.util.TextUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;

public class Mail
extends SpaceContentEntityObject {
    private static final Logger log = Logger.getLogger(Mail.class);
    public static final int MESSAGE_ID_SIZE = 255;
    public static final int MESSAGE_SUBJECT_SIZE = 255;
    public static final String CONTENT_TYPE = "mail";
    private MimeMessage message;
    private String messageId;
    private String inReplyTo;
    private List references;
    private static final Pattern messageIdPattern = Pattern.compile("<\\S+>");
    private String canonicalSubject;
    public static final String DEFAULT_NO_SUBJECT = "[No Subject]";
    private static final int START = 0;
    private static final int POSSIBLE = 1;
    private static final int NEXT = 2;
    private static final int UNTIL = 3;

    public String getType() {
        return CONTENT_TYPE;
    }

    public String getContent() {
        return super.getContent().replaceFirst("^\\r?\\n", "");
    }

    public String getUrlPath() {
        if (this.getId() != 0L && this.getSpace() != null) {
            return "/display/" + this.getSpace().getKey() + "/mail/" + this.getId();
        }
        return null;
    }

    public MimeMessage getMimeMessage() throws MessagingException {
        if (this.message == null && this.getContent() != null) {
            this.message = new MimeMessage(null, (InputStream)new ByteArrayInputStream(this.getContent().getBytes()));
        }
        return this.message;
    }

    public void loadContent(InputStream in) throws IOException {
        int read;
        StringBuffer messageBuffer = new StringBuffer();
        InputStreamReader reader = new InputStreamReader(in, "UTF-8");
        char[] buf = new char[1024];
        while ((read = reader.read(buf)) != -1) {
            messageBuffer.append(buf, 0, read);
        }
        this.setContent(messageBuffer.toString());
    }

    public void setContent(String content) {
        while (content != null && content.length() > 1 && Character.isWhitespace(content.charAt(0))) {
            content = content.substring(1);
        }
        super.setContent(content);
    }

    public String getTitle() {
        if (!TextUtils.stringSet((String)super.getTitle())) {
            this.setTitle(this.getDisplayableSubject());
        }
        return super.getTitle();
    }

    public boolean hasSubject() {
        try {
            return TextUtils.stringSet((String)this.getMimeMessage().getSubject());
        }
        catch (MessagingException e) {
            log.warn((Object)("Could not parse mail into a MimeMessage: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public String getSubject() {
        try {
            if (this.hasSubject()) {
                return this.getMimeMessage().getSubject().trim();
            }
            return null;
        }
        catch (MessagingException e) {
            log.warn((Object)("Could not parse mail into a MimeMessage: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public String getDisplayableSubject() {
        if (this.hasSubject()) {
            return this.getSubject();
        }
        return DEFAULT_NO_SUBJECT;
    }

    public String getCanonicalSubject() {
        if (this.canonicalSubject == null) {
            this.canonicalSubject = Mail.canonicalizeSubject(this.getSubject());
        }
        return this.canonicalSubject;
    }

    public String getDisplayableCanonicalSubject() {
        if (this.hasSubject()) {
            return this.getCanonicalSubject();
        }
        return DEFAULT_NO_SUBJECT;
    }

    public String getMessageId() {
        if (!TextUtils.stringSet((String)this.messageId)) {
            try {
                this.messageId = this.getMimeMessage().getMessageID();
            }
            catch (MessagingException e) {
                log.warn((Object)("Could not parse mail into a MimeMessage: " + e.getMessage()), (Throwable)e);
            }
        }
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getMessageBody() {
        try {
            return this.getMimeMessage().getContent().toString();
        }
        catch (MessagingException e) {
            log.warn((Object)("Could not parse mail into a MimeMessage: " + e.getMessage()), (Throwable)e);
            return null;
        }
        catch (IOException e) {
            log.warn((Object)("Could not retrieve content of mail: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public void setMimeMessage(MimeMessage message) {
        try {
            this.message = message;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (message.getContent() != null) {
                message.writeTo((OutputStream)out);
                String content = new String(out.toByteArray(), "UTF-8");
                this.setContent(content);
            } else {
                this.setContent("");
            }
            Date creationDate = message.getReceivedDate();
            if (creationDate == null) {
                creationDate = message.getSentDate();
            }
            this.setCreationDate(creationDate);
            String title = this.getDisplayableSubject();
            if (title != null && title.length() > 255) {
                log.warn((Object)("long subject will be truncated: " + title));
                title = title.substring(0, 255);
            }
            this.setTitle(title);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)("Unexpected exception dealing with internal IO streams: " + e.getMessage()), (Throwable)e);
            throw new InfrastructureException("Unexpected exception dealing with internal IO streams: " + e.getMessage(), (Throwable)e);
        }
    }

    public String getInReplyTo() {
        if (this.inReplyTo == null) {
            try {
                String[] values = this.getMimeMessage().getHeader("In-Reply-To");
                this.inReplyTo = values != null && values.length > 0 ? this.extractLastMessageId(values[0]) : "";
            }
            catch (MessagingException e) {
                log.warn((Object)("Could not parse mail into a MimeMessage: " + e.getMessage()), (Throwable)e);
            }
        }
        return this.inReplyTo;
    }

    private String extractLastMessageId(String replyToHeader) {
        Matcher matcher = messageIdPattern.matcher(replyToHeader);
        String id = "";
        while (matcher.find()) {
            id = matcher.group(0);
        }
        return id;
    }

    public List getReferences() {
        if (this.references == null) {
            try {
                ArrayList<String> tmpReferences = new ArrayList<String>();
                String[] values = this.getMimeMessage().getHeader("References");
                if (values != null && values.length > 0) {
                    this.extractReferencesFromHeader(tmpReferences, values[0]);
                }
                if (TextUtils.stringSet((String)this.getInReplyTo()) && !tmpReferences.contains(this.getInReplyTo())) {
                    tmpReferences.add(this.inReplyTo);
                }
                this.references = tmpReferences;
            }
            catch (MessagingException e) {
                log.warn((Object)("Could not parse mail into a MimeMessage: " + e.getMessage()), (Throwable)e);
            }
        }
        return this.references;
    }

    public Address[] getFrom() {
        Address[] from = null;
        try {
            from = this.getMimeMessage().getFrom();
        }
        catch (MessagingException e) {
            log.warn((Object)("Could not parse mail into a MimeMessage: " + e.getMessage()), (Throwable)e);
        }
        return from == null ? new Address[]{} : from;
    }

    public List getFromForSearch() {
        return this.toAddressPieces(this.getFrom());
    }

    public List getRecipientsForSearch() {
        return this.toAddressPieces(this.getRecipients());
    }

    private List toAddressPieces(Address[] addresses) {
        ArrayList<String> addressBits = new ArrayList<String>();
        for (int i = 0; i < addresses.length; ++i) {
            Address address = addresses[i];
            if (address instanceof InternetAddress) {
                addressBits.add(((InternetAddress)address).toUnicodeString());
                continue;
            }
            addressBits.add(address.toString());
        }
        return addressBits;
    }

    public Address[] getRecipients() {
        Address[] recipients = null;
        try {
            recipients = this.getMimeMessage().getAllRecipients();
        }
        catch (MessagingException e) {
            log.warn((Object)("Could not parse mail into a MimeMessage: " + e.getMessage()), (Throwable)e);
        }
        return recipients == null ? new Address[]{} : recipients;
    }

    public Date getSentDate() {
        try {
            return this.getMimeMessage().getSentDate();
        }
        catch (MessagingException e) {
            log.warn((Object)("Could not parse mail into a MimeMessage: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public Date getCreationDate() {
        return super.getCreationDate();
    }

    public String getExcerpt() {
        return RendererUtil.summariseWithoutStrippingWikiCharacters((String)this.getUnquotedTextForSummary());
    }

    private void extractReferencesFromHeader(List references, String headerValue) {
        if (TextUtils.stringSet((String)headerValue)) {
            String[] subRefs = headerValue.split("\\s+");
            for (int i = 0; i < subRefs.length; ++i) {
                references.add(subRefs[i]);
            }
        }
    }

    public String getUnquotedTextForSummary() {
        StringBuffer buf = new StringBuffer();
        String lastLine = "";
        String lastTry = "";
        try {
            String line;
            String body = this.getMessageBody();
            BufferedReader r = new BufferedReader(new StringReader(body));
            int state = 0;
            boolean reading = true;
            while (reading && (line = r.readLine()) != null && !"--".equals(line = line.trim())) {
                switch (state) {
                    case 0: {
                        if (line.length() == 0 || !Character.isLetterOrDigit(line.charAt(0))) break;
                        lastLine = line;
                        state = 1;
                        break;
                    }
                    case 1: {
                        if (line.length() == 0) break;
                        if (!Character.isLetterOrDigit(line.charAt(0))) {
                            state = 2;
                            break;
                        }
                        buf.append(lastLine).append(" ");
                        buf.append(line).append(" ");
                        state = 3;
                        break;
                    }
                    case 2: {
                        if (line.length() == 0 || !Character.isLetterOrDigit(line.charAt(0))) break;
                        buf.append(line).append(" ");
                        state = 3;
                        break;
                    }
                    case 3: {
                        if (line.length() > 0 && !Character.isLetterOrDigit(line.charAt(0)) || line.length() == 0 && buf.length() > 80) {
                            if (buf.length() > 80) {
                                reading = false;
                            }
                            if (buf.length() > lastTry.length()) {
                                lastTry = buf.toString();
                            }
                            state = 2;
                            buf.setLength(0);
                            break;
                        }
                        buf.append(line).append(" ");
                    }
                }
            }
        }
        catch (IOException e) {
            log.info((Object)("Error getting unquoted mail text: " + e.getMessage()));
        }
        if (lastTry.length() == 0 && lastLine.length() != 0) {
            lastTry = lastLine;
        }
        if (lastTry.length() < buf.length()) {
            lastTry = buf.toString();
        }
        if (lastTry.length() == 0) {
            return this.getMessageBody();
        }
        return lastTry;
    }

    static String canonicalizeSubject(String title) {
        if (!TextUtils.stringSet((String)title)) {
            return title;
        }
        String simplifiedTitle = title.trim();
        simplifiedTitle = simplifiedTitle.replaceFirst("^[rR][eE]([\\[\\(]\\d+[\\]\\)])?:(.*)", "$2");
        simplifiedTitle = simplifiedTitle.replaceFirst("^[aA][wW]([\\[\\(]\\d+[\\]\\)])?:(.*)", "$2");
        if (!(simplifiedTitle = simplifiedTitle.replaceFirst("^\\[[fF][wW][dD]:(.*)\\]$", "$1")).equals(title)) {
            return Mail.canonicalizeSubject(simplifiedTitle);
        }
        return simplifiedTitle;
    }
}

