/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail;

import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.bonnie.LuceneConnection;
import com.atlassian.confluence.mail.Mail;
import com.atlassian.confluence.mail.ThreadNode;
import com.atlassian.util.profiling.UtilTimerStack;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.log4j.Category;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class ThreadBuilder {
    private static Category log = Category.getInstance(ThreadBuilder.class);
    private LuceneConnection luceneConnection;
    private Stack toLookUp = new Stack();
    private Set lookedUp = new HashSet();
    private Map docs = new HashMap();
    private Map docCache = new HashMap();
    private String spaceKey;
    private boolean called;
    private Set searchedSubjects = new HashSet();
    private String originalMessageId;

    public void setLuceneConnection(LuceneConnection luceneConnection) {
        this.luceneConnection = luceneConnection;
    }

    public ThreadNode buildThreadAround(String spaceKey, String messageId) {
        this.checkNotAlreadyUsed();
        this.originalMessageId = messageId;
        UtilTimerStack.push((String)("ThreadBuilder: " + messageId));
        try {
            this.spaceKey = spaceKey;
            this.findAllMailRelatedTo(messageId);
        }
        catch (Exception e) {
            log.error((Object)("Unable to search message thread: " + e.getMessage()), (Throwable)e);
        }
        ThreadNode retval = this.buildThreadFromDocuments(this.docs);
        UtilTimerStack.pop((String)("ThreadBuilder: " + messageId));
        return retval;
    }

    private void findAllMailRelatedTo(String messageId) {
        this.toLookUp.add(messageId);
        while (!this.toLookUp.isEmpty()) {
            this.processNextId();
        }
    }

    private void processNextId() {
        String messageId = (String)this.toLookUp.pop();
        this.addThisDoc(messageId);
        final BooleanQuery query = new BooleanQuery();
        query.add((Query)new TermQuery(new Term("spacekey", this.spaceKey)), BooleanClause.Occur.MUST);
        query.add((Query)new TermQuery(new Term("classname", Mail.class.getName())), BooleanClause.Occur.MUST);
        query.add((Query)new TermQuery(new Term("references", messageId)), BooleanClause.Occur.MUST);
        this.luceneConnection.withSearch(new ILuceneConnection.SearcherAction(){

            public boolean perform(IndexSearcher searcher) throws IOException {
                Hits documents = searcher.search((Query)query);
                for (int i = 0; i < documents.length(); ++i) {
                    Document doc = documents.doc(i);
                    String referencingMessageId = doc.get("messageid");
                    ThreadBuilder.this.docCache.put(referencingMessageId, doc);
                    ThreadBuilder.this.addIdToSearchList(referencingMessageId);
                }
                return true;
            }
        });
    }

    private ThreadNode buildThreadFromDocuments(Map docs) {
        Map nodesById = this.toNodeMap(docs);
        for (Map.Entry entry : docs.entrySet()) {
            String messageId = (String)entry.getKey();
            Document doc = (Document)entry.getValue();
            String[] references = doc.getValues("references");
            if (references == null || references.length <= 0) continue;
            this.linkReferencedMessages(nodesById, messageId, references);
        }
        return this.makeSingleRootedThread(nodesById);
    }

    private ThreadNode makeSingleRootedThread(Map nodesById) {
        List unparentedNodes = this.getUnparentedNodes(nodesById);
        if (unparentedNodes.size() > 1) {
            this.cleanUpUnparentedNodesBySubject(nodesById.values(), unparentedNodes);
        }
        for (ThreadNode threadNode : unparentedNodes) {
            if (threadNode.getNodeWithMessageId(this.originalMessageId) == null) continue;
            return threadNode;
        }
        return ThreadNode.getEmptyThreadNode();
    }

    private void cleanUpUnparentedNodesBySubject(Collection allNodes, List unparentedNodes) {
        Iterator it = unparentedNodes.iterator();
        while (it.hasNext()) {
            ThreadNode threadNode = (ThreadNode)it.next();
            ThreadNode parent = this.findPossibleParentBySubject(threadNode, allNodes);
            if (parent == null) continue;
            threadNode.setParent(parent);
            if (threadNode.getParent() == null) continue;
            it.remove();
        }
    }

    private ThreadNode findPossibleParentBySubject(ThreadNode orphanedNode, Collection allNodes) {
        for (ThreadNode potentialParent : allNodes) {
            if (potentialParent == orphanedNode || !TextUtils.stringSet((String)orphanedNode.getCanonicalSubject()) || !orphanedNode.getCanonicalSubject().equals(potentialParent.getTitle())) continue;
            return potentialParent;
        }
        return null;
    }

    private void linkReferencedMessages(Map nodesById, String messageId, String[] references) {
        if (nodesById.containsKey(references[references.length - 1])) {
            ((ThreadNode)nodesById.get(messageId)).setParent((ThreadNode)nodesById.get(references[references.length - 1]));
        } else if (references.length > 1) {
            for (int i = references.length - 2; i >= 0; --i) {
                if (!nodesById.containsKey(references[i])) continue;
                ThreadNode dummyParent = ThreadNode.getEmptyThreadNode();
                ((ThreadNode)nodesById.get(messageId)).setParent(dummyParent);
                dummyParent.setParent((ThreadNode)nodesById.get(references[references.length - 1]));
                break;
            }
        }
    }

    private Map toNodeMap(Map docs) {
        HashMap nodeMap = new HashMap();
        for (Map.Entry entry : docs.entrySet()) {
            Document doc = (Document)entry.getValue();
            nodeMap.put(entry.getKey(), new ThreadNode(this.toId(doc.get("handle")), doc));
        }
        return nodeMap;
    }

    private void addThisDoc(final String messageId) {
        this.lookedUp.add(messageId);
        if (this.docCache.containsKey(messageId)) {
            this.addThisDoc(messageId, (Document)this.docCache.get(messageId));
        } else {
            final BooleanQuery query = new BooleanQuery();
            query.add((Query)new TermQuery(new Term("spacekey", this.spaceKey)), BooleanClause.Occur.MUST);
            query.add((Query)new TermQuery(new Term("messageid", messageId)), BooleanClause.Occur.MUST);
            query.add((Query)new TermQuery(new Term("classname", Mail.class.getName())), BooleanClause.Occur.MUST);
            this.luceneConnection.withSearch(new ILuceneConnection.SearcherAction(){

                public boolean perform(IndexSearcher searcher) throws IOException {
                    Hits hits = searcher.search((Query)query);
                    if (hits.length() != 0) {
                        ThreadBuilder.this.addThisDoc(messageId, hits.doc(0));
                    }
                    return true;
                }
            });
        }
    }

    private void addThisDoc(String messageId, Document doc) {
        this.docs.put(messageId, doc);
        this.addReferencedMessages(doc);
        String canonicalSubject = doc.get("canonicalsubject");
        if (TextUtils.stringSet((String)canonicalSubject)) {
            this.addMessagesWithSameSubject(canonicalSubject);
        }
    }

    private void addMessagesWithSameSubject(String canonicalSubject) {
        if (!this.searchedSubjects.contains(canonicalSubject)) {
            this.searchedSubjects.add(canonicalSubject);
            final BooleanQuery query = new BooleanQuery();
            query.add((Query)new TermQuery(new Term("spacekey", this.spaceKey)), BooleanClause.Occur.MUST);
            query.add((Query)new TermQuery(new Term("canonicalsubject", canonicalSubject)), BooleanClause.Occur.MUST);
            query.add((Query)new TermQuery(new Term("classname", Mail.class.getName())), BooleanClause.Occur.MUST);
            this.luceneConnection.withSearch(new ILuceneConnection.SearcherAction(){

                public boolean perform(IndexSearcher searcher) throws IOException {
                    Hits hits = searcher.search((Query)query);
                    for (int i = 0; i < hits.length(); ++i) {
                        Document doc = hits.doc(i);
                        ThreadBuilder.this.docCache.put(doc.get("messageid"), doc);
                        ThreadBuilder.this.addIdToSearchList(doc.get("messageid"));
                    }
                    return true;
                }
            });
        }
    }

    private void addReferencedMessages(Document doc) {
        String[] referencedDocs = doc.getValues("references");
        if (referencedDocs != null) {
            for (int i = 0; i < referencedDocs.length; ++i) {
                String referencedId = referencedDocs[i];
                this.addIdToSearchList(referencedId);
            }
        }
    }

    private long toId(String s) {
        return Long.parseLong(s.substring(Mail.class.getName().length() + 1));
    }

    private void addIdToSearchList(String messageId) {
        if (!this.toLookUp.contains(messageId) && !this.lookedUp.contains(messageId)) {
            this.toLookUp.add(messageId);
        }
    }

    private List getUnparentedNodes(Map nodesById) {
        ArrayList<ThreadNode> unparentedNodes = new ArrayList<ThreadNode>();
        for (ThreadNode node : nodesById.values()) {
            if (node.getParent() != null) continue;
            unparentedNodes.add(node);
        }
        return unparentedNodes;
    }

    private void checkNotAlreadyUsed() {
        if (this.called) {
            throw new IllegalStateException("Attempting to re-use a single-use object");
        }
        this.called = true;
    }
}

