/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.actions;

import com.atlassian.confluence.mail.AbstractMailAccount;
import com.atlassian.confluence.mail.ImapMailAccount;
import com.atlassian.confluence.mail.PopMailAccount;
import com.atlassian.confluence.mail.actions.AbstractMailAccountAction;
import com.atlassian.confluence.spaces.actions.SpaceAdministrative;
import com.atlassian.core.util.PairType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class AddMailAccountAction
extends AbstractMailAccountAction
implements SpaceAdministrative {
    public String doDefault() throws Exception {
        this.setProtocol("pop3");
        this.setPort(110);
        return super.doDefault();
    }

    public String execute() throws Exception {
        AbstractMailAccount mailAccount = null;
        if (this.getProtocol().indexOf("pop3") != -1) {
            mailAccount = new PopMailAccount(0, this.name, this.description, this.hostname, this.username, this.password, this.port, this.getProtocol().endsWith("s"));
        } else if (this.getProtocol().indexOf("imap") != -1) {
            mailAccount = new ImapMailAccount(0, this.name, this.description, this.hostname, this.username, this.password, this.port, this.getProtocol().endsWith("s"));
        } else {
            throw new UnsupportedOperationException("Protocol: " + this.getProtocol() + " not supported.");
        }
        if ("Test Connection".equals(this.getConfirm())) {
            this.pollResult = this.mailAccountManager.updateAccountStatus(mailAccount);
            return "testconnection";
        }
        this.mailAccountManager.updateAccountStatus(mailAccount);
        this.mailAccountManager.addMailAccount(this.getSpace(), mailAccount);
        return "success";
    }

    public List getProtocolList() {
        ArrayList<PairType> result = new ArrayList<PairType>();
        result.add(new PairType((Serializable)((Object)"pop3"), (Serializable)((Object)"POP")));
        result.add(new PairType((Serializable)((Object)"imap"), (Serializable)((Object)"IMAP")));
        result.add(new PairType((Serializable)((Object)"pop3s"), (Serializable)((Object)"POPS")));
        result.add(new PairType((Serializable)((Object)"imaps"), (Serializable)((Object)"IMAPS")));
        return result;
    }
}

