/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.actions;

import com.atlassian.confluence.mail.MailAccount;
import com.atlassian.confluence.mail.actions.AbstractMailAccountAction;
import com.atlassian.confluence.spaces.actions.SpaceAdministrative;
import com.atlassian.core.util.PairType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class EditMailAccountAction
extends AbstractMailAccountAction
implements SpaceAdministrative {
    private int id;

    public String doDefault() throws Exception {
        MailAccount mailAccount = this.mailAccountManager.getMailAccount(this.getSpace(), this.getId());
        this.setName(mailAccount.getName());
        this.setDescription(mailAccount.getDescription());
        this.setHostname(mailAccount.getHostname());
        this.setProtocol(mailAccount.getProtocol());
        this.setUsername(mailAccount.getUsername());
        this.setPassword(mailAccount.getPassword());
        this.setPort(mailAccount.getPort());
        this.setSecure(mailAccount.isSecure());
        return super.doDefault();
    }

    public String execute() throws Exception {
        MailAccount mailAccount = this.mailAccountManager.getMailAccount(this.getSpace(), this.getId());
        mailAccount.setName(this.getName());
        mailAccount.setDescription(this.getDescription());
        mailAccount.setHostname(this.getHostname());
        mailAccount.setUsername(this.getUsername());
        mailAccount.setPassword(this.getPassword());
        mailAccount.setPort(this.getPort());
        mailAccount.setSecure(this.isSecure());
        if (this.getProtocol().endsWith("s")) {
            mailAccount.setSecure(true);
        }
        if ("Test Connection".equals(this.getConfirm())) {
            this.pollResult = this.mailAccountManager.updateAccountStatus(mailAccount);
            return "testconnection";
        }
        this.mailAccountManager.updateAccountStatus(mailAccount);
        this.mailAccountManager.updateAccount(this.getSpace(), mailAccount);
        return "success";
    }

    public List getProtocolList() {
        ArrayList<PairType> result = new ArrayList<PairType>();
        if (this.getProtocol().indexOf("pop3") != -1) {
            result.add(new PairType((Serializable)((Object)"pop3"), (Serializable)((Object)"POP")));
            result.add(new PairType((Serializable)((Object)"pop3s"), (Serializable)((Object)"POPS")));
        } else if (this.getProtocol().indexOf("imap") != -1) {
            result.add(new PairType((Serializable)((Object)"imap"), (Serializable)((Object)"IMAP")));
            result.add(new PairType((Serializable)((Object)"imaps"), (Serializable)((Object)"IMAPS")));
        } else {
            throw new UnsupportedOperationException(this.getProtocol() + " no supported.");
        }
        return result;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }
}

