/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.actions;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.mail.actions.AbstractMailAction;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.core.bean.EntityObject;
import java.util.Iterator;
import java.util.List;
import javax.mail.Address;
import org.apache.log4j.Logger;

public class RemoveMailAction
extends AbstractMailAction {
    private static final Logger log = Logger.getLogger(RemoveMailAction.class);
    private ConfluenceIndexer indexer;

    public String doRemove() throws Exception {
        log.debug((Object)"starting mail removal");
        this.getMail().trash();
        log.debug((Object)"trashed mail.  Unindexing mail...");
        this.unIndex(this.getMail());
        log.debug((Object)"Mail unindexed.");
        return "success";
    }

    public String execute() throws Exception {
        return "success";
    }

    private void unIndex(EntityObject eo) {
        if (this.indexer != null && eo instanceof Searchable) {
            Iterator it = ((Searchable)eo).getSearchableDependants().iterator();
            while (it.hasNext()) {
                this.unIndex((EntityObject)it.next());
            }
            this.indexer.unIndex((Searchable)eo);
        }
    }

    public ConfluenceIndexer getIndexer() {
        return this.indexer;
    }

    public void setIndexer(ConfluenceIndexer indexer) {
        this.indexer = indexer;
    }

    public String getSender(Address[] address) {
        if (address.length > 0) {
            return address[0].toString();
        }
        return this.getText("anonymous.name");
    }

    protected List getPermissionTypes() {
        List permissionTypes = super.getPermissionTypes();
        this.addPermissionTypeTo("REMOVEMAIL", permissionTypes);
        return permissionTypes;
    }
}

