/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.actions;

import com.atlassian.confluence.mail.Mail;
import com.atlassian.confluence.mail.ThreadBuilder;
import com.atlassian.confluence.mail.ThreadNode;
import com.atlassian.confluence.mail.actions.AbstractMailAction;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.util.GeneralUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ViewMailAction
extends AbstractMailAction {
    private static final Logger log = Logger.getLogger(ViewMailAction.class);
    private ThreadBuilder threadBuilder;
    private ThreadNode containingThread;
    private AttachmentManager attachmentManager;
    private Mail nextMail;
    private Mail previousMail;
    private List highlight = new ArrayList();

    public void validate() {
        if (this.getMail() == null) {
            this.addActionError(this.getText("error.unable.to.determine.thread", new Object[]{"" + this.id}));
        }
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public String execute() throws Exception {
        if (this.getMail() != null) {
            this.addToHistory(this.getMail());
        }
        return super.execute();
    }

    public void setThreadBuilder(ThreadBuilder threadBuilder) {
        this.threadBuilder = threadBuilder;
    }

    public Mail getNextMail() {
        if (this.nextMail == null) {
            this.nextMail = this.mailContentManager.getFirstMailAfter(this.getMail().getSpaceKey(), this.getMail().getId());
        }
        return this.nextMail;
    }

    public Mail getPreviousMail() {
        if (this.previousMail == null) {
            this.previousMail = this.mailContentManager.getFirstMailBefore(this.getMail().getSpaceKey(), this.getMail().getId());
        }
        return this.previousMail;
    }

    public int getTotalThreadCount() {
        return this.getContainingThread().getDescendentsCount() + 1;
    }

    public int getVisibleThreadCount() {
        return this.getPositionInThread().getVisibleThreadCount();
    }

    public List getParents(int maxParentsToReturn) {
        ArrayList<ThreadNode> parents = new ArrayList<ThreadNode>();
        ThreadNode node = this.getPositionInThread();
        if (node != null) {
            while ((node = node.getParent()) != null) {
                parents.add(0, node);
            }
        }
        if (maxParentsToReturn <= 0 || parents.size() < maxParentsToReturn) {
            return parents;
        }
        return parents.subList(parents.size() - maxParentsToReturn, parents.size());
    }

    public boolean isInThread() {
        return this.getPositionInThread() != null && !this.getPositionInThread().isIsolated();
    }

    public ThreadNode getPositionInThread() {
        return this.getContainingThread().getNodeWithMessageId(this.getMail().getMessageId());
    }

    public ThreadNode getContainingThread() {
        try {
            if (this.containingThread == null) {
                this.containingThread = this.threadBuilder.buildThreadAround(this.getMail().getSpaceKey(), this.getMail().getMessageId());
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to determine containing thread: " + e), (Throwable)e);
        }
        return this.containingThread;
    }

    public Boolean getAttachmentsShowing() {
        return this.getUserInterfaceState().getAttachmentsShowing();
    }

    public void setShowAttachments(Boolean showAttachments) {
        this.getUserInterfaceState().setAttachmentsShowing(showAttachments);
    }

    public boolean isAttachmentsInWebDavFolder() {
        return this.getAttachmentsWebDavUrl() != null;
    }

    public String getAttachmentsWebDavUrl() {
        return this.settingsManager.getGlobalSettings().getWebdavServerUrl();
    }

    public String getAttachmentsWebDavUrlForPage() {
        String serverUrl = this.getAttachmentsWebDavUrl();
        if (!serverUrl.endsWith("/")) {
            serverUrl = serverUrl + "/";
        }
        return serverUrl + this.getMail().getIdAsString() + "/";
    }

    public String getExcerpt(long mailId) {
        Mail mailToExcerpt = this.mailContentManager.getMailById(mailId);
        if (mailToExcerpt == null) {
            return this.getText("error.mail.not.found");
        }
        return mailToExcerpt.getExcerpt();
    }

    public List getLatestVersionsOfAttachments() {
        return this.attachmentManager.getLatestVersionsOfAttachments(this.getMail());
    }

    public List getHighlight() {
        return this.highlight;
    }

    public void setHighlight(List names) {
        this.highlight = names;
    }

    public String[] getAttachmentDetails(Attachment attachment) {
        return new String[]{GeneralUtil.escapeXml(attachment.getFileName()), String.valueOf(attachment.getVersion())};
    }
}

