/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.importers;

import com.atlassian.confluence.mail.Mail;
import com.atlassian.confluence.mail.MailContentManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.io.IOUtils;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Logger;
import org.springframework.orm.hibernate.HibernateTransactionManager;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class MboxImporter
extends ConfluenceAbstractLongRunningTask {
    private static final Logger log = Logger.getLogger(MboxImporter.class);
    private static final byte[] delim = new byte[]{10, 10, 70, 114, 111, 109, 32};
    private Space space;
    private MailContentManager mailContentManager;
    private SessionFactory sessionFactory;
    private HibernateTransactionManager transactionManager;
    private int imported = 0;
    private long startTime;
    private long last100Time;
    private File file;
    private InputStream input;
    private List addedMails = new ArrayList(100);

    public void setSpace(Space space) {
        this.space = space;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setInputStream(InputStream input) {
        this.input = input;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setMailContentManager(MailContentManager mailContentManager) {
        this.mailContentManager = mailContentManager;
    }

    public void setTransactionManager(HibernateTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void runInternal() {
        new TransactionTemplate((PlatformTransactionManager)this.transactionManager).execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                try {
                    MboxImporter.this.space = (Space)SessionFactoryUtils.getSession((SessionFactory)MboxImporter.this.sessionFactory, (boolean)true).load(Space.class, (Serializable)new Long(MboxImporter.this.space.getId()));
                    MboxImporter.this.importMbox();
                    MboxImporter.this.progress.setStatus("Import complete");
                    MboxImporter.this.progress.setPercentage(100);
                    log.info((Object)("Imported " + MboxImporter.this.imported + " emails in " + (System.currentTimeMillis() - MboxImporter.this.startTime) / 1000L + " seconds."));
                }
                catch (Exception e) {
                    log.error((Object)("Mailbox import failed: " + e.getMessage()), (Throwable)e);
                    MboxImporter.this.progress.setStatus("Import failed: " + e.getMessage());
                    MboxImporter.this.progress.setPercentage(100);
                    MboxImporter.this.progress.setCompletedSuccessfully(false);
                }
            }
        });
    }

    public void importMbox() throws IOException {
        if (this.file != null) {
            this.progress.setStatus("Scanning mailbox");
            this.progress.setTotalObjects(this.estimateTotalMailCount(this.file));
            log.info((Object)("Total mail to import: " + this.progress.getTotal()));
            this.input = new FileInputStream(this.file);
        }
        this.doImport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int estimateTotalMailCount(File mboxFile) throws IOException {
        int n;
        int count = 0;
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(mboxFile), "ISO-8859-1"));
            while ((line = in.readLine()) != null) {
                if (!line.startsWith("From ")) continue;
                ++count;
            }
            n = count;
        }
        catch (Throwable throwable) {
            IOUtils.close(in);
            throw throwable;
        }
        IOUtils.close(in);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doImport() throws IOException {
        this.startTime = this.last100Time = System.currentTimeMillis();
        ByteArrayOutputStream message = new ByteArrayOutputStream();
        BufferedInputStream in = null;
        try {
            int b;
            in = new BufferedInputStream(this.input);
            int pos = 0;
            while ((b = in.read()) != -1) {
                if (b == 13) continue;
                if (b == delim[pos]) {
                    if (++pos != delim.length) continue;
                    this.nextMail(message);
                    pos = 0;
                    message.reset();
                    message.write(new byte[]{70, 114, 111, 109, 32});
                    continue;
                }
                if (pos != 0 && (pos != 2 || b != 10)) {
                    message.write(delim, 0, pos);
                    pos = 0;
                }
                message.write(b);
            }
            this.nextMail(message);
        }
        catch (Throwable throwable) {
            IOUtils.close(in);
            throw throwable;
        }
        IOUtils.close(in);
    }

    private void nextMail(ByteArrayOutputStream message) {
        MimeMessage mimeMessage = null;
        try {
            mimeMessage = new MimeMessage(null, (InputStream)new ByteArrayInputStream(message.toByteArray()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Importing mail message " + mimeMessage.getMessageID()));
            }
            this.progress.setStatus("Importing message " + mimeMessage.getMessageID() + "(" + (this.imported + 1) + "/" + this.progress.getTotal() + ")");
            this.progress.setCurrentCount(this.imported);
            this.progress.setPercentage(this.imported, this.progress.getTotal());
            this.addedMails.add(this.mailContentManager.storeIncomingMail(this.space, mimeMessage));
            if (++this.imported % 100 == 0) {
                log.info((Object)("Imported " + this.imported + " emails. Last 100 in " + (System.currentTimeMillis() - this.last100Time) / 1000L + " seconds"));
                this.last100Time = System.currentTimeMillis();
                this.periodicFlush();
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to import a message, index: " + (this.imported + 1) + ". " + this.buildIdentificationStringForEmail(mimeMessage)), (Throwable)e);
        }
    }

    private String buildIdentificationStringForEmail(MimeMessage mimeMessage) {
        if (mimeMessage == null) {
            return "MIME Message is null";
        }
        try {
            String subject = mimeMessage.getSubject();
            return "Subject: " + subject;
        }
        catch (MessagingException e) {
            log.error((Object)"Unable to get subject from MIME message", (Throwable)e);
            return "Message subject unreadable";
        }
    }

    private void periodicFlush() throws HibernateException {
        Session session = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
        session.flush();
        for (Mail mail : this.addedMails) {
            session.evict((Object)mail);
        }
        this.addedMails.clear();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Flush took " + (System.currentTimeMillis() - this.last100Time) + "ms"));
        }
    }

    public String getName() {
        return "Importing mailbox file";
    }
}

