/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.notification;

import com.atlassian.confluence.event.events.content.mail.notification.ContentNotificationAddedEvent;
import com.atlassian.confluence.event.events.content.mail.notification.ContentNotificationRemovedEvent;
import com.atlassian.confluence.event.events.content.mail.notification.NotificationEvent;
import com.atlassian.confluence.event.events.content.mail.notification.SiteNotificationAddedEvent;
import com.atlassian.confluence.event.events.content.mail.notification.SiteNotificationRemovedEvent;
import com.atlassian.confluence.event.events.content.mail.notification.SpaceNotificationAddedEvent;
import com.atlassian.confluence.event.events.content.mail.notification.SpaceNotificationRemovedEvent;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.mail.notification.persistence.NotificationDao;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import com.atlassian.user.User;
import java.util.List;

public class DefaultNotificationManager
implements NotificationManager {
    private NotificationDao notificationDao;
    private EventManager eventManager;

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public NotificationDao getNotificationDao() {
        return this.notificationDao;
    }

    public void setNotificationDao(NotificationDao notificationDao) {
        this.notificationDao = notificationDao;
    }

    public List getNotificationsByUser(User user) {
        return this.notificationDao.findNotificationsByUser(user);
    }

    public Notification getNotificationByUserAndPage(User user, AbstractPage page) {
        return this.notificationDao.findNotificationByUserAndPage(user, page);
    }

    public Notification getNotificationByUserAndSpace(User user, String spaceKey) {
        return this.notificationDao.findNotificationByUserAndSpace(user, spaceKey);
    }

    public Notification addPageNotification(User user, AbstractPage page) {
        return this.addNotification(user, null, page);
    }

    public Notification addSpaceNotification(User user, Space space) {
        return this.addNotification(user, space, null);
    }

    protected Notification addNotification(User user, Space space, AbstractPage page) {
        if (space == null && page == null) {
            return null;
        }
        Notification notification = page == null ? this.getNotificationByUserAndSpace(user, space.getKey()) : this.getNotificationByUserAndPage(user, page);
        if (notification == null) {
            notification = new Notification();
            notification.setUserName(user.getName());
            notification.setSpace(space);
            notification.setPage(page);
            this.notificationDao.save(notification);
            this.eventManager.publishEvent((Event)this.makeNotificationAddedEvent(notification));
            return notification;
        }
        return notification;
    }

    private NotificationEvent makeNotificationAddedEvent(Notification notification) {
        if (notification.getPage() != null) {
            return new ContentNotificationAddedEvent(this, notification);
        }
        if (notification.getSpace() != null) {
            return new SpaceNotificationAddedEvent(this, notification);
        }
        return new SiteNotificationAddedEvent(this, notification);
    }

    private NotificationEvent makeNotificationRemovedEvent(Notification notification) {
        if (notification.getPage() != null) {
            return new ContentNotificationRemovedEvent(this, notification);
        }
        if (notification.getSpace() != null) {
            return new SpaceNotificationRemovedEvent(this, notification);
        }
        return new SiteNotificationRemovedEvent(this, notification);
    }

    public void removeNotification(Notification notification) {
        this.notificationDao.remove(notification);
        this.eventManager.publishEvent((Event)this.makeNotificationRemovedEvent(notification));
    }

    public boolean isUserWatchingPageOrSpace(User user, Space space, AbstractPage page) {
        Notification pageNotif = null;
        Notification spaceNotif = null;
        if (page != null) {
            pageNotif = this.notificationDao.findNotificationByUserAndPage(user, page);
        }
        if (space != null) {
            spaceNotif = this.notificationDao.findNotificationByUserAndSpace(user, space.getKey());
        }
        return pageNotif != null || spaceNotif != null;
    }

    public List getNotificationsByPage(AbstractPage page) {
        return this.notificationDao.findNotificationsByPage(page);
    }

    public List getNotificationsBySpace(Space space) {
        return this.notificationDao.findNotificationsBySpace(space);
    }

    public void removeAllNotificationsForUser(User user) {
        List notifications = this.notificationDao.findNotificationsByUser(user);
        for (Notification notification : notifications) {
            this.removeNotification(notification);
        }
        this.notificationDao.removeDailyReportNotificationForUser(user.getName());
    }

    public List getDailyReportNotifications() {
        return this.notificationDao.findAllDailyReportNotifications();
    }

    public Notification getDailyReportNotificationForUser(User user) {
        return this.notificationDao.findDailyReportNotification(user.getName());
    }

    public Notification addDailyReportNotfication(User user) {
        Notification notification = this.notificationDao.findDailyReportNotification(user.getName());
        if (notification == null) {
            notification = new Notification();
            notification.setUserName(user.getName());
            this.notificationDao.save(notification);
        }
        return notification;
    }

    public void removeDailyReportNotification(User user) {
        this.notificationDao.removeDailyReportNotificationForUser(user.getName());
    }
}

