/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.notification.actions;

import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;

public class PageNotificationBean {
    private PageManager pageManager;
    private NotificationManager notificationManager;

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void startWatching(String entityIdString) {
        long entityId = Long.parseLong(entityIdString);
        AbstractPage entity = this.pageManager.getAbstractPage(entityId);
        User user = AuthenticatedUserThreadLocal.getUser();
        this.notificationManager.addPageNotification(user, entity);
    }

    public void stopWatching(String entityIdString) {
        long entityId = Long.parseLong(entityIdString);
        AbstractPage entity = this.pageManager.getAbstractPage(entityId);
        User user = AuthenticatedUserThreadLocal.getUser();
        Notification notif = this.notificationManager.getNotificationByUserAndPage(user, entity);
        if (notif != null) {
            this.notificationManager.removeNotification(notif);
        }
    }
}

