/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.notification.listeners;

import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentEvent;
import com.atlassian.confluence.event.events.content.comment.CommentRemoveEvent;
import com.atlassian.confluence.mail.notification.listeners.AbstractNotificationsListener;
import com.atlassian.confluence.mail.notification.listeners.NotificationData;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.event.Event;
import com.atlassian.user.User;

public class CommentNotificationsListener
extends AbstractNotificationsListener {
    public static final Class[] HANDLED_EVENTS = new Class[]{CommentCreateEvent.class, CommentRemoveEvent.class};

    public void handleEvent(Event event) {
        CommentEvent commentEvent = (CommentEvent)event;
        Comment comment = commentEvent.getComment();
        AbstractPage page = comment.getPage();
        Space space = page.getSpace();
        User modifier = this.getLastModifier(comment);
        NotificationData notificationData = new NotificationData(modifier);
        notificationData.setPermissionsCheck(this.makeViewEntityPermissionsCheck(page));
        notificationData.addToContext("page", page);
        notificationData.addToContext("space", space);
        notificationData.addToContext("comment", comment);
        notificationData.setSubject("$space.name > $page.title");
        if (event instanceof CommentCreateEvent) {
            notificationData.setTemplateName("addcomment-notification.vm");
        } else if (event instanceof CommentRemoveEvent) {
            notificationData.setTemplateName("removecomment-notification.vm");
            notificationData.addToContext("remover", ((CommentRemoveEvent)event).getOriginatingUser());
        }
        this.sendSpaceNotifications(space, notificationData);
        this.sendPageNotifications(page, notificationData);
    }

    public Class[] getHandledEventClasses() {
        return HANDLED_EVENTS;
    }
}

