/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.notification.listeners;

import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.content.page.PageMoveEvent;
import com.atlassian.confluence.event.events.content.page.PageTrashedEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.mail.notification.listeners.AbstractNotificationsListener;
import com.atlassian.confluence.mail.notification.listeners.NotificationData;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.event.Event;
import com.atlassian.user.User;

public class PageNotificationsListener
extends AbstractNotificationsListener {
    public static final Class[] HANDLED_EVENTS = new Class[]{PageCreateEvent.class, PageUpdateEvent.class, PageTrashedEvent.class, PageMoveEvent.class};
    private PageManager pageManager;

    public void handleEvent(Event event) {
        PageEvent pageEvent = (PageEvent)event;
        Page page = pageEvent.getPage();
        Space space = page.getSpace();
        User modifier = this.getLastModifier(page);
        NotificationData notificationData = new NotificationData(modifier);
        notificationData.setPermissionsCheck(this.makeViewEntityPermissionsCheck(page));
        notificationData.addToContext("page", page);
        notificationData.addToContext("space", space);
        boolean shouldNotify = true;
        notificationData.setSubject("$space.name > $page.title");
        if (event instanceof PageCreateEvent) {
            notificationData.setTemplateName("createpage-notification.vm");
        } else if (event instanceof PageTrashedEvent) {
            notificationData.setTemplateName("removepage-notification.vm");
            notificationData.addToContext("trasher", ((PageTrashedEvent)event).getOriginatingUser());
        } else if (event instanceof PageMoveEvent) {
            PageMoveEvent pageMoveEvent = (PageMoveEvent)pageEvent;
            Space oldSpace = pageMoveEvent.getOldSpace();
            Page oldParentPage = pageMoveEvent.getOldParentPage();
            if (oldSpace.equals(page.getSpace()) && this.parentPageUnchanged(oldParentPage, page.getParent())) {
                return;
            }
            notificationData.setTemplateName("movepage-notification.vm");
            notificationData.addToContext("movedUser", pageMoveEvent.getUser());
            notificationData.addToContext("oldSpace", oldSpace);
            notificationData.addToContext("oldParentPage", oldParentPage);
            notificationData.addToContext("movedChildren", new Boolean(pageMoveEvent.hasMovedChildren()));
            if (pageMoveEvent.hasMovedChildren()) {
                notificationData.addToContext("childrenPages", this.pageManager.getDescendents(page));
            }
        } else if (((PageUpdateEvent)event).isMinorEdit()) {
            shouldNotify = false;
        } else {
            PageUpdateEvent pageUpdateEvent = (PageUpdateEvent)event;
            notificationData.addToContext("originalPage", pageUpdateEvent.getOriginalPage());
            notificationData.setTemplateName("editpage-notification.vm");
        }
        if (shouldNotify) {
            this.sendSpaceNotifications(space, notificationData);
            this.sendPageNotifications(page, notificationData);
        }
    }

    private boolean parentPageUnchanged(Page oldParentPage, Page newParentPage) {
        if (oldParentPage == newParentPage) {
            return true;
        }
        if (oldParentPage != null) {
            return oldParentPage.equals(newParentPage);
        }
        return newParentPage.equals(oldParentPage);
    }

    public Class[] getHandledEventClasses() {
        return HANDLED_EVENTS;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }
}

