/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.notification.persistence.dao.hibernate;

import com.atlassian.confluence.core.persistence.hibernate.ConfluenceHibernateObjectDao;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.persistence.NotificationDao;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.user.User;
import java.sql.SQLException;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Category;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class HibernateNotificationDao
extends ConfluenceHibernateObjectDao
implements NotificationDao {
    Category log = Category.getInstance(HibernateNotificationDao.class);

    public List findNotificationsByUser(User user) {
        return this.findNamedQueryStringParam("confluence.notifications_findNotificationsByUser", "userName", user.getName());
    }

    public List findNotificationsByPage(AbstractPage page) {
        return this.findNamedQueryStringParam("confluence.notifications_findNotificationsByPage", "pageId", new Long(page.getId()));
    }

    public List findNotificationsBySpace(Space space) {
        return this.findNamedQueryStringParam("confluence.notifications_findNotificationsBySpace", "spaceId", new Long(space.getId()));
    }

    public Notification findNotificationByUserAndPage(User user, AbstractPage page) {
        List result = this.findNamedQueryStringParams("confluence.notifications_findNotificationsByUserAndPage", "userName", user.getName(), "pageId", new Long(page.getId()), true);
        if (result.size() == 0) {
            return null;
        }
        if (result.size() > 1) {
            this.log.warn((Object)("There seems to be more than one notification entry for user: " + user.getName() + " and page: " + page.getTitle()));
        }
        return (Notification)result.get(0);
    }

    public Notification findNotificationByUserAndSpace(User user, String spaceKey) {
        List result = this.findNamedQueryStringParams("confluence.notifications_findNotificationsByUserAndSpace", "userName", user.getName(), "spaceKey", spaceKey, true);
        if (result.size() == 0) {
            return null;
        }
        if (result.size() > 1) {
            this.log.warn((Object)("There seems to be more than one notification entry for user: " + user.getName() + " and space: " + spaceKey));
        }
        return (Notification)result.get(0);
    }

    public void removeAllNotificationsForUser(User user) {
        List list = this.findNotificationsByUser(user);
        for (Notification notification : list) {
            this.remove(notification);
        }
    }

    public void removeDailyReportNotificationForUser(final String username) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query queryObject = session.getNamedQuery("confluence.notifications_findDailyReportNotificationByUser");
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateNotificationDao.this.getSessionFactory());
                queryObject.setString("userName", username);
                List notifications = queryObject.list();
                for (Notification notification : notifications) {
                    session.delete((Object)notification);
                }
                return null;
            }
        });
    }

    public Notification findDailyReportNotification(String username) {
        return (Notification)this.findSingleObject(this.findNamedQueryStringParam("confluence.notifications_findDailyReportNotificationByUser", "userName", username, true));
    }

    public List findAllDailyReportNotifications() {
        return this.findNamedQuery("confluence.notifications_findDailyReportNotifications", true);
    }

    public Class getPersistentClass() {
        return Notification.class;
    }
}

