/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.persistence.dao.hibernate;

import com.atlassian.confluence.core.persistence.hibernate.ContentEntityObjectHibernateDao;
import com.atlassian.confluence.mail.Mail;
import com.atlassian.confluence.mail.persistence.dao.MailDao;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.core.db.JDBCUtils;
import com.opensymphony.util.TextUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class HibernateMailDao
extends ContentEntityObjectHibernateDao
implements MailDao {
    public Class getPersistentClass() {
        return Mail.class;
    }

    public Mail getMailById(long id) {
        return (Mail)super.getByClassId(id);
    }

    public Mail getMailByMessageId(String messageId) {
        if (messageId == null) {
            return null;
        }
        return (Mail)this.findSingleObject(this.findNamedQueryStringParam("confluence.mail_findByMessageId", "messageId", messageId));
    }

    public List getMailsByMessageId(String messageId) {
        if (messageId == null) {
            return Collections.EMPTY_LIST;
        }
        return this.findNamedQueryStringParam("confluence.mail_findByMessageId", "messageId", messageId);
    }

    public Mail getMostRecentMail(String spaceKey) {
        if (!TextUtils.stringSet((String)spaceKey)) {
            return null;
        }
        return (Mail)this.findSingleObject(this.findNamedQueryStringParam("confluence.mail_findRecentlyAddedMailForSpace", "spaceKey", spaceKey.toLowerCase(), true, 1));
    }

    public Mail getFirstMailAfter(String spaceKey, long mailId) {
        if (!TextUtils.stringSet((String)spaceKey)) {
            return null;
        }
        return (Mail)this.findSingleObject(this.findNamedQueryStringParams("confluence.mail_findMailAfter", "spaceKey", spaceKey.toLowerCase(), "mailId", new Long(mailId), true, 1));
    }

    public Mail getFirstMailBefore(String spaceKey, long mailId) {
        if (!TextUtils.stringSet((String)spaceKey)) {
            return null;
        }
        return (Mail)this.findSingleObject(this.findNamedQueryStringParams("confluence.mail_findMailBefore", "spaceKey", spaceKey.toLowerCase(), "mailId", new Long(mailId), true, 1));
    }

    public Iterator getSpaceMailIterator(final String spaceKey) {
        return (Iterator)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery("confluence.mail_findAllMailForSpace");
                queryObject.setParameter("spaceKey", (Object)spaceKey.toLowerCase());
                queryObject.setCacheable(true);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateMailDao.this.getSessionFactory());
                return queryObject.iterate();
            }
        });
    }

    public Iterator getSpaceMailWithAttachmentsIterator(final String spaceKey) {
        return (Iterator)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery("confluence.mail_findAllMailForSpaceWithAttachments");
                queryObject.setParameter("spaceKey", (Object)spaceKey.toLowerCase());
                queryObject.setCacheable(true);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateMailDao.this.getSessionFactory());
                return queryObject.iterate();
            }
        });
    }

    public int findMailTotal(final Space space) {
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("confluence.mail_getMailCount");
                query.setParameter("spaceid", (Object)new Long(space.getId()));
                return query.iterate().next();
            }
        });
    }

    public List getSpaceMail(final int firstResult, final int maxResults, final String spaceKey) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery("confluence.mail_findAllMailForSpace");
                queryObject.setParameter("spaceKey", (Object)spaceKey.toLowerCase());
                queryObject.setFirstResult(firstResult);
                queryObject.setMaxResults(maxResults);
                queryObject.setCacheable(true);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateMailDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
    }

    public List getMail(final Space space, final boolean currentOnly) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = currentOnly ? session.getNamedQuery("confluence.mail_findCurrentMailForSpace") : session.getNamedQuery("confluence.mail_findMailForSpace");
                queryObject.setParameter("spaceid", (Object)new Long(space.getId()));
                queryObject.setCacheable(true);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateMailDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
    }

    public void removeAllMail(final Space space) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                session.flush();
                Connection c = session.connection();
                PreparedStatement mailselect = null;
                PreparedStatement bodyContentDelete = null;
                PreparedStatement maildelete = null;
                ResultSet rs = null;
                try {
                    mailselect = c.prepareStatement("select CONTENTID from CONTENT where SPACEID = ? and CONTENT_STATUS = 'current' and CONTENTTYPE = 'MAIL'");
                    bodyContentDelete = c.prepareStatement("delete from BODYCONTENT where CONTENTID = ?");
                    maildelete = c.prepareStatement("DELETE from CONTENT where SPACEID = ? and CONTENT_STATUS = 'current' and CONTENTTYPE = 'MAIL'");
                    mailselect.setLong(1, space.getId());
                    rs = mailselect.executeQuery();
                    while (rs.next()) {
                        long contentId = rs.getLong(1);
                        bodyContentDelete.setLong(1, contentId);
                        bodyContentDelete.execute();
                        bodyContentDelete.clearParameters();
                    }
                    maildelete.setLong(1, space.getId());
                    maildelete.execute();
                    HibernateMailDao.this.getSessionFactory().evict(Mail.class);
                    HibernateMailDao.this.getSessionFactory().evictQueries();
                }
                catch (Throwable throwable) {
                    JDBCUtils.close(rs);
                    JDBCUtils.close(bodyContentDelete);
                    JDBCUtils.close((Statement)mailselect);
                    JDBCUtils.close(maildelete);
                    throw throwable;
                }
                JDBCUtils.close((ResultSet)rs);
                JDBCUtils.close((Statement)bodyContentDelete);
                JDBCUtils.close((Statement)mailselect);
                JDBCUtils.close((Statement)maildelete);
                return null;
            }
        });
    }
}

