/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.reports;

import com.atlassian.confluence.mail.reports.ChangeDigestStats;
import com.atlassian.confluence.mail.reports.CommentReport;
import com.atlassian.confluence.mail.reports.PageReport;
import com.atlassian.confluence.mail.reports.PersonalInfoReport;
import com.atlassian.confluence.mail.reports.SpaceReport;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class ChangeDigestReport {
    private User user;
    private SortedMap spaceReportsBySpaceKey = new TreeMap(Collator.getInstance());
    private TreeMap changedPersonalInfos = new TreeMap();
    private ChangeDigestStats stats;
    private UserAccessor userAccessor;
    private long coverPeriod = 86400000L;

    public ChangeDigestReport(User user, UserAccessor userAccessor) {
        this.user = user;
        this.userAccessor = userAccessor;
    }

    UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    public void addPage(Page page) {
        this.getSpaceReport(page.getSpace()).addPage(new PageReport(page, this));
    }

    public void addBlogPost(BlogPost blogPost) {
        this.getSpaceReport(blogPost.getSpace()).addBlogPost(new PageReport(blogPost, this));
    }

    public void addComment(Comment comment) {
        this.getSpaceReport(comment.getPage().getSpace()).addComment(new CommentReport(comment, this));
    }

    public List getSpaces() {
        return this.getSpaceReports();
    }

    public List getSpaceReports() {
        return new ArrayList(this.spaceReportsBySpaceKey.values());
    }

    public Iterator getSpaceIterator() {
        return this.getSpaceReports().iterator();
    }

    public User getUser() {
        return this.user;
    }

    public long getCoverPeriod() {
        return this.coverPeriod;
    }

    public void setCoverPeriod(long coverPeriod) {
        this.coverPeriod = coverPeriod;
    }

    public ChangeDigestStats getStats() {
        if (this.stats == null) {
            this.stats = new ChangeDigestStats(this);
        }
        return this.stats;
    }

    public void setStats(ChangeDigestStats stats) {
        this.stats = stats;
    }

    private SpaceReport getSpaceReport(Space space) {
        SpaceReport spaceReport = (SpaceReport)this.spaceReportsBySpaceKey.get(space.getKey());
        if (spaceReport == null) {
            spaceReport = new SpaceReport(space, this);
            this.spaceReportsBySpaceKey.put(space.getKey(), spaceReport);
        }
        return spaceReport;
    }

    public void addPersonalInformation(PersonalInformation personalInformation) {
        PersonalInfoReport personalInfoReport = new PersonalInfoReport(personalInformation, this);
        if (personalInfoReport.getLastModifierName() == null) {
            return;
        }
        if (personalInfoReport.getLastModifierName().equals(personalInformation.getUsername())) {
            this.changedPersonalInfos.put(personalInfoReport.getPersonalInformation().getUsername(), personalInfoReport);
        }
    }

    public Collection getChangedPersonalInformation() {
        return this.changedPersonalInfos.values();
    }

    public boolean hasChanges() {
        for (SpaceReport spaceReport : this.getSpaceReports()) {
            if (spaceReport.getChangeSize() <= 0) continue;
            return true;
        }
        return false;
    }
}

