/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.template;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.util.ConfluenceRenderUtils;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.core.task.Task;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.velocity.VelocityContextUtils;
import com.opensymphony.util.TextUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractMailNotificationQueueItem
implements MailQueueItem,
Task {
    protected final transient Logger log = Logger.getLogger(this.getClass());
    private String lastError = null;
    protected Date dateQueued;
    private int timesSent = 0;
    private String subject;
    public static final String MIME_TYPE_HTML = "text/html";
    public static final String MIME_TYPE_TEXT = "text/plain";
    private String templateFileName;
    private String templateContent;
    private String templateLocation;
    protected String body;
    private Map context = new HashMap();

    public AbstractMailNotificationQueueItem(String templateContent) {
        this.templateContent = templateContent;
    }

    public AbstractMailNotificationQueueItem(String templateLocation, String templateFileName) {
        if (!templateLocation.endsWith("/")) {
            templateLocation = templateLocation + "/";
        }
        this.templateLocation = templateLocation;
        this.templateFileName = templateFileName;
    }

    public String getLastError() {
        return this.lastError;
    }

    protected void setLastError(String lastError) {
        this.lastError = lastError;
    }

    public String getSubject() {
        return this.subject;
    }

    public Date getDateQueued() {
        return this.dateQueued;
    }

    public int getSendCount() {
        return this.timesSent;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public boolean hasError() {
        return this.timesSent > 0;
    }

    public void execute() throws Exception {
        this.send();
    }

    public void send() throws MailException {
        this.addVelocityContextParam("subject", this.subject);
        Email mail = this.createMailObject();
        if (mail != null) {
            SMTPMailServer mailServer = this.retrieveMailServer();
            if (mailServer == null) {
                String errorMessage = "Unable to send email since no mail server has been configured.";
                this.log.error((Object)errorMessage);
                this.setLastError(errorMessage);
                return;
            }
            try {
                mailServer.send(mail);
            }
            catch (MailException me) {
                this.setLastError(me.toString());
                throw me;
            }
        }
    }

    protected abstract Email createMailObject();

    protected SMTPMailServer retrieveMailServer() throws MailException {
        return MailFactory.getServerManager().getDefaultSMTPMailServer();
    }

    protected void incrementSendCount() {
        ++this.timesSent;
    }

    protected static boolean isRecognisedMimeType(String mimePref) {
        return mimePref.equals(MIME_TYPE_HTML) || mimePref.equals(MIME_TYPE_TEXT);
    }

    private Map getInitialContext() {
        Map context = MacroUtils.defaultVelocityContext();
        String domainName = GeneralUtil.getGlobalSettings().getBaseUrl();
        if (StringUtils.isNotBlank((String)domainName) && domainName.endsWith("/")) {
            domainName = domainName.substring(0, domainName.length() - 1);
        }
        if (StringUtils.isBlank((String)domainName)) {
            this.log.warn((Object)"The base url was not retrieved from Global Settings. This will lead to $baseUrl appearing in mail notifications");
        }
        context.put("baseurl", domainName);
        BootstrapManager bootstrapManager = (BootstrapManager)BootstrapUtils.getBootstrapManager();
        String contextPath = bootstrapManager.getWebAppContextPath();
        if (TextUtils.stringSet((String)contextPath) && !contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        context.put("contextPath", contextPath);
        context.put("stylesheet", ConfluenceRenderUtils.renderDefaultStylesheet());
        context.put("resourceBundle", GeneralUtil.getI18n().getResourceBundle());
        context.put("i18nBean", GeneralUtil.getI18n());
        context.putAll(this.context);
        return context;
    }

    public void addVelocityContextParam(String name, Object value) {
        this.context.put(name, value);
    }

    public Object removeVelocityContextParam(String name) {
        return this.context.remove(name);
    }

    public void clearContext() {
        this.context.clear();
    }

    public Object getVelocityContextParam(String name) {
        return this.context.get(name);
    }

    public void preRenderBody(Map contextMap) {
        Map map = this.getInitialContext();
        map.putAll(contextMap);
        this.body = VelocityUtils.getRenderedTemplate(this.templateLocation + this.templateFileName, map);
    }

    public String getRenderedContent(String content) {
        Map contextMap = VelocityContextUtils.getContextParamsBody((Map)this.getInitialContext());
        if (content != null) {
            this.body = VelocityUtils.getRenderedContent(content, contextMap);
        }
        return this.body;
    }

    public String getRenderedContent() {
        if (this.templateContent != null) {
            return this.getRenderedContent(this.templateContent);
        }
        Map contextMap = VelocityContextUtils.getContextParamsBody((Map)this.getInitialContext());
        String templateUrl = this.templateLocation + this.templateFileName;
        this.body = VelocityUtils.getRenderedTemplate(templateUrl, contextMap);
        return this.body;
    }

    public String getTemplateFileName() {
        return this.templateFileName;
    }

    public void setTemplateFileName(String templateFileName) {
        this.templateFileName = templateFileName;
    }

    public String getTemplateContent() {
        return this.templateContent;
    }

    public void setTemplateContent(String templateContent) {
        this.templateContent = templateContent;
    }

    public String getTemplateLocation() {
        return this.templateLocation;
    }

    public void setTemplateLocation(String templateLocation) {
        this.templateLocation = templateLocation;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }
}

