/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.template;

import com.atlassian.confluence.mail.template.MultipartBuilder;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.server.SMTPMailServer;
import java.io.IOException;
import java.util.Date;
import javax.mail.MessagingException;
import org.apache.log4j.Category;

public class ConfluenceMailQueueItem
implements MailQueueItem {
    private static final Category log = Category.getInstance(ConfluenceMailQueueItem.class);
    public static final String MIME_TYPE_HTML = "text/html";
    public static final String MIME_TYPE_TEXT = "text/plain";
    private String toAddress;
    private String ccAddress;
    private String fromAddress;
    private String fromName;
    private String subject;
    private String body;
    private String mimeType;
    private boolean sendLogs;
    private String logsLocation;
    private boolean hasError;
    private String lastError;
    private int sendCount;
    private Date dateQueued;

    public void setSendLogs(boolean sendLogs) {
        this.sendLogs = sendLogs;
    }

    public void setLogsLocation(String logsLocation) {
        this.logsLocation = logsLocation;
    }

    public ConfluenceMailQueueItem(String toAddress, String subject, String body, String mimeType) {
        this.toAddress = toAddress;
        this.subject = subject;
        this.body = body;
        this.mimeType = mimeType;
        this.dateQueued = new Date();
    }

    public ConfluenceMailQueueItem(String toAddress, String ccAddress, String subject, String body, String mimeType) {
        this(toAddress, subject, body, mimeType);
        this.ccAddress = ccAddress;
    }

    public void send() throws MailException {
        SMTPMailServer smtpServer;
        ++this.sendCount;
        Email email = new Email(this.toAddress);
        email.setSubject(this.subject);
        email.setBody(this.body);
        email.setMimeType(this.mimeType);
        if (this.ccAddress != null) {
            email.setCc(this.ccAddress);
        }
        if ((smtpServer = MailFactory.getServerManager().getDefaultSMTPMailServer()) == null) {
            this.lastError = "Unable to send email since no mail server has been configured.";
            this.hasError = true;
        } else {
            if (this.sendLogs) {
                try {
                    email.setMultipart(MultipartBuilder.INSTANCE.buildMartipart(this.logsLocation));
                }
                catch (MessagingException e) {
                    log.error((Object)("Unable to attach log files for message : " + this.subject), (Throwable)e);
                }
                catch (IOException e) {
                    log.error((Object)("Unable to attach log files for message : " + this.subject), (Throwable)e);
                }
            }
            try {
                smtpServer.send(email);
                this.hasError = false;
            }
            catch (MailException me) {
                log.error((Object)("Unable to send email with subject '" + this.subject + "' to <" + this.toAddress + "> reason: " + me.getMessage()), (Throwable)me);
                this.hasError = true;
                this.lastError = me.getMessage();
                throw me;
            }
        }
    }

    public String getSubject() {
        return this.subject;
    }

    public Date getDateQueued() {
        return this.dateQueued;
    }

    public int getSendCount() {
        return this.sendCount;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public void execute() throws Exception {
        this.send();
    }

    public String getLastError() {
        return this.lastError;
    }

    public String getBody() {
        return this.body;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public String getFromName() {
        return this.fromName;
    }

    public void setFromName(String fromName) {
        this.fromName = fromName;
    }
}

