/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.template;

import com.atlassian.confluence.mail.template.AbstractMailNotificationQueueItem;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.user.preferences.UserPreferences;
import com.atlassian.mail.Email;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import java.util.Date;

public class MailNotificationQueueItem
extends AbstractMailNotificationQueueItem {
    public static final String TEMPLATES_LOCATION = "/templates/email/";
    private static UserAccessor userAccessor;
    private String userName;
    private String mimeType = "text/plain";

    public static MailNotificationQueueItem createFromTemplateFile(User user, String templateFileName, String subject) {
        String templateType = "text";
        if ("text/html".equals(MailNotificationQueueItem.getMimeTypeForUser(user))) {
            templateType = "html";
        }
        String templateLocation = TEMPLATES_LOCATION + templateType + "/";
        return MailNotificationQueueItem.createFromTemplateFileAndLocation(user, templateLocation, templateFileName, subject);
    }

    public static MailNotificationQueueItem createFromTemplateFileAndLocation(User user, String templateLocation, String templateFileName, String subject) {
        return new MailNotificationQueueItem(user, templateLocation, templateFileName, subject);
    }

    public static MailNotificationQueueItem createFromTemplateContent(User user, String templateContent, String subject) {
        return new MailNotificationQueueItem(user, templateContent, subject);
    }

    protected MailNotificationQueueItem(User user, String templateLocation, String templateFileName, String subject) {
        super(templateLocation, templateFileName);
        this.setSubject(subject);
        this.checkUser(user, subject);
        this.userName = user.getName();
        this.dateQueued = new Date();
        if (TextUtils.stringSet((String)MailNotificationQueueItem.getMimeTypeForUser(user))) {
            this.mimeType = MailNotificationQueueItem.getMimeTypeForUser(user);
        }
    }

    protected MailNotificationQueueItem(User user, String templateContent, String subject) {
        super(templateContent);
        this.setSubject(subject);
        this.checkUser(user, subject);
        this.userName = user.getName();
        this.dateQueued = new Date();
        if (TextUtils.stringSet((String)MailNotificationQueueItem.getMimeTypeForUser(user))) {
            this.mimeType = MailNotificationQueueItem.getMimeTypeForUser(user);
        }
    }

    private void checkUser(User user, String subject) {
        if (user == null) {
            throw new IllegalArgumentException("null user for mail notification item with subject " + subject);
        }
        if (user.getEmail() == null) {
            throw new IllegalArgumentException("user " + user.getName() + " has null email address for mail notification item with subject " + subject);
        }
    }

    protected String getMimeType() {
        return this.mimeType;
    }

    protected Email createMailObject() {
        String messageBody = this.getRenderedContent();
        Email mail = null;
        User user = MailNotificationQueueItem.getUserAccessor().getUser(this.userName);
        if (user != null) {
            mail = new Email(user.getEmail());
            mail.setEncoding("UTF-8");
            mail.setSubject(this.getSubject());
            mail.setBody(messageBody);
            mail.setMimeType(this.mimeType);
            this.setLastError(null);
        }
        return mail;
    }

    protected static String getMimeTypeForUser(User user) {
        UserPreferences prefs = new UserPreferences(MailNotificationQueueItem.getUserAccessor().getPropertySet(user));
        String mimePref = prefs.getString("confluence.prefs.email.mimetype");
        if (mimePref == null || !MailNotificationQueueItem.isRecognisedMimeType(mimePref)) {
            mimePref = "text/html";
        }
        return mimePref;
    }

    public static UserAccessor getUserAccessor() {
        if (userAccessor == null) {
            userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        }
        return userAccessor;
    }
}

